/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.fugue.Option;
import com.atlassian.plugins.codegen.ClassId;
import com.atlassian.plugins.codegen.ComponentDeclaration;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.Dependencies;
import com.atlassian.plugins.codegen.modules.jira.RPCProperties;

@JiraPluginModuleCreator
public class RPCModuleCreator
extends AbstractPluginModuleCreator<RPCProperties> {
    public static final String MODULE_NAME = "RPC Endpoint Plugin";
    private static final String TEMPLATE_PREFIX = "templates/jira/rpc/";
    private static final String CLASS_TEMPLATE = "templates/jira/rpc/RPCService.java.vtl";
    private static final String INTERFACE_TEMPLATE = "templates/jira/rpc/RPCServiceInterface.java.vtl";
    private static final String UNIT_TEST_TEMPLATE = "templates/generic/GenericTest.java.vtl";
    private static final String EXAMPLE_CLASS_TEMPLATE = "templates/jira/rpc/Exampletemplates/jira/rpc/RPCService.java.vtl";
    private static final String SOAP_PLUGIN_MODULE_TEMPLATE = "templates/jira/rpc/soap-rpc-plugin.xml.vtl";
    private static final String XML_PLUGIN_MODULE_TEMPLATE = "templates/jira/rpc/xml-rpc-plugin.xml.vtl";

    @Override
    public PluginProjectChangeset createModule(RPCProperties props) throws Exception {
        String moduleKey = props.getModuleKey() + "-component";
        String description = "Component For " + props.getModuleName();
        String name = props.getModuleName() + " Component";
        String nameI18nKey = props.getNameI18nKey() + ".component";
        PluginProjectChangeset ret = new PluginProjectChangeset().with(new PluginProjectChange[]{Dependencies.HTTPCLIENT_TEST, Dependencies.MOCKITO_TEST}).with(this.createModule(props, props.isSoap() ? SOAP_PLUGIN_MODULE_TEMPLATE : XML_PLUGIN_MODULE_TEMPLATE));
        ret = props.includeExamples() ? ret.with(this.createClass(props, EXAMPLE_CLASS_TEMPLATE)) : ret.with(this.createClassAndTests(props, CLASS_TEMPLATE, UNIT_TEST_TEMPLATE)).with(this.createClass(props, props.getInterfaceId(), INTERFACE_TEMPLATE));
        ComponentDeclaration component = ComponentDeclaration.builder((ClassId)props.getClassId(), (String)moduleKey).interfaceId(Option.option((Object)props.getInterfaceId())).description(Option.some((Object)description)).name(Option.some((Object)name)).nameI18nKey(Option.some((Object)nameI18nKey)).build();
        return ret.with(new PluginProjectChange[]{component});
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

