/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import io.atlassian.fugue.Option;
import java.util.Objects;

public final class VersionId {
    private final Option<String> version;
    private final Option<String> propertyName;

    public static VersionId version(String version) {
        return new VersionId((Option<String>)Option.some((Object)version), (Option<String>)Option.none(String.class));
    }

    public static VersionId versionProperty(String propertyName, String defaultVersion) {
        return new VersionId((Option<String>)Option.some((Object)defaultVersion), (Option<String>)Option.some((Object)propertyName));
    }

    public static VersionId noVersion() {
        return new VersionId((Option<String>)Option.none(String.class), (Option<String>)Option.none(String.class));
    }

    private VersionId(Option<String> version, Option<String> propertyName) {
        this.version = Objects.requireNonNull(version, "version");
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName");
    }

    public Option<String> getVersion() {
        return this.version;
    }

    public Option<String> getPropertyName() {
        return this.propertyName;
    }

    public boolean isDefined() {
        return this.version.isDefined() || this.propertyName.isDefined();
    }

    public Option<String> getVersionOrPropertyPlaceholder() {
        return this.propertyPlaceholder().orElse(this.version);
    }

    public String toString() {
        return (String)this.propertyPlaceholder().map(placeholder -> placeholder + this.defaultValueSuffix()).orElse(this.version).getOrElse((Object)"?");
    }

    private String defaultValueSuffix() {
        return (String)this.version.map(v -> " (" + v + ")").getOrElse((Object)"");
    }

    private Option<String> propertyPlaceholder() {
        return this.propertyName.map(property -> "${" + property + "}");
    }

    public boolean equals(Object other) {
        if (other instanceof VersionId) {
            VersionId v = (VersionId)other;
            return this.version.equals(v.version) && this.propertyName.equals(v.propertyName);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

