/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.util;

import com.atlassian.annotations.Internal;

@Internal
public abstract class Char {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String EN_DASH = "\u2013";
    public static final String EM_DASH = "\u2014";
    public static final String LEFT_GUILLEMET = "\u00ab";
    public static final String RIGHT_GUILLEMET = "\u00bb";
    public static final String NBSP = "\u00a0";
    public static final String IDEOGRAPHIC_SPACE = "\u3000";
    public static final String PAPERCLIP = "\ud83d\udcce";
    public static final String WJ = "\u2060";

    private Char() {
    }

    public static boolean isAlpha(char c) {
        return Char.isLower(c) || Char.isUpper(c);
    }

    public static boolean isAlnum(char c) {
        return Char.isAlpha(c) || Char.isDigit(c);
    }

    public static boolean isHexit(char c) {
        return Char.isDigit(c) || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u3000': {
                return true;
            }
        }
        return false;
    }

    public static boolean isNonBreakingSpace(char c) {
        return c == '\u00a0';
    }

    public static boolean isLineTerminator(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case '\u0085': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    public static char hex(int hexit) {
        return HEX[hexit];
    }
}

