/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.Alignment;
import com.atlassian.adf.model.mark.Indentation;
import com.atlassian.adf.model.mark.type.ParagraphMark;
import com.atlassian.adf.model.mark.type.PositionMark;
import com.atlassian.adf.model.mark.type.TextMark;
import com.atlassian.adf.model.node.AbstractMarkedContentNode;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.BlockquoteContent;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionFrameContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.PanelContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Paragraph
extends AbstractMarkedContentNode<Paragraph, InlineContent, ParagraphMark>
implements BlockquoteContent,
DocContent,
ExtensionFrameContent,
LayoutColumnContent,
ListItemContent,
NestedExpandContent,
NonNestableBlockContent,
PanelContent,
TableCellContent {
    static Factory<Paragraph> FACTORY = new Factory<Paragraph>("paragraph", Paragraph.class, Paragraph::parse);
    @Nullable
    private String localId;

    private Paragraph() {
    }

    public static Paragraph p() {
        return new Paragraph();
    }

    public static Paragraph p(String content) {
        return Paragraph.p((InlineContent)Text.text(content));
    }

    public static Paragraph p(String ... content) {
        return Paragraph.p(Arrays.stream(content).map(Text::text));
    }

    public static Paragraph p(InlineContent content) {
        return (Paragraph)Paragraph.p().content(content);
    }

    public static Paragraph p(InlineContent ... content) {
        return (Paragraph)Paragraph.p().content(content);
    }

    public static Paragraph p(Iterable<? extends InlineContent> content) {
        return (Paragraph)Paragraph.p().content(content);
    }

    public static Paragraph p(Stream<? extends InlineContent> content) {
        return (Paragraph)Paragraph.p().content(content);
    }

    public static Paragraph paragraph() {
        return new Paragraph();
    }

    public static Paragraph paragraph(String content) {
        return Paragraph.paragraph((InlineContent)Text.text(content));
    }

    public static Paragraph paragraph(String ... content) {
        return Paragraph.paragraph(Arrays.stream(content).map(Text::text));
    }

    public static Paragraph paragraph(InlineContent content) {
        return (Paragraph)Paragraph.paragraph().content(content);
    }

    public static Paragraph paragraph(InlineContent ... content) {
        return (Paragraph)Paragraph.paragraph().content(content);
    }

    public static Paragraph paragraph(Iterable<? extends InlineContent> content) {
        return (Paragraph)Paragraph.paragraph().content(content);
    }

    public static Paragraph paragraph(Stream<? extends InlineContent> content) {
        return (Paragraph)Paragraph.paragraph().content(content);
    }

    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    public Paragraph localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    public Paragraph text(String content) {
        return (Paragraph)this.content(Text.text(content));
    }

    public Paragraph text(String content, TextMark mark) {
        return (Paragraph)this.content(Text.text(content, mark));
    }

    public Paragraph text(String content, TextMark ... marks) {
        return (Paragraph)this.content(Text.text(content, marks));
    }

    public Paragraph text(String ... content) {
        return (Paragraph)this.content(Text.text(content));
    }

    public Paragraph alignment(Alignment alignment) {
        return this.mark(alignment);
    }

    public Paragraph center() {
        return this.mark(Alignment.center());
    }

    public Paragraph end() {
        return this.mark(Alignment.end());
    }

    public Paragraph indentation(Indentation indentation) {
        return this.mark(indentation);
    }

    public Paragraph indentation(int level) {
        return this.mark(Indentation.indentation(level));
    }

    @Override
    public Paragraph mark(ParagraphMark mark) {
        super.mark(mark);
        if (mark instanceof PositionMark) {
            this.restrictPositionMarks((PositionMark)((Object)mark));
        }
        return this;
    }

    @Override
    public boolean markIfAllowed(ParagraphMark mark) {
        boolean ok = super.markIfAllowed(mark);
        if (ok && mark instanceof PositionMark) {
            this.restrictPositionMarks((PositionMark)((Object)mark));
        }
        return ok;
    }

    @Override
    public Class<ParagraphMark> markClass() {
        return ParagraphMark.class;
    }

    @Override
    public Class<InlineContent> contentClass() {
        return InlineContent.class;
    }

    @Override
    public Paragraph copy() {
        return Paragraph.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "paragraph";
    }

    @Override
    public Map<String, ?> toMap() {
        FieldMap attrs = FieldMap.map().addIfPresent("localId", this.localId);
        return this.mapWithType().let(this::addContentIfPresent).let(this.marks::addToMap).addIf(!attrs.isEmpty(), "attrs", () -> attrs);
    }

    private static Paragraph parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "paragraph");
        Paragraph paragraph = (Paragraph)((Paragraph)Paragraph.p().parseOptionalContent(map, InlineContent.class)).parseMarks(map);
        ParserSupport.getAttr(map, "localId", String.class).ifPresent(paragraph::localId);
        return paragraph;
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        this.appendPlainTextInlineContent(sb);
    }

    void disableMarks(ContentNode<?, ? super Paragraph> parent) {
        this.marks.disable(parent.elementType());
    }

    private void restrictPositionMarks(PositionMark markThatWasThereFirst) {
        Class<?> allowedClass = markThatWasThereFirst.getClass();
        String reason = "Only one PositionMark is permitted, and '" + markThatWasThereFirst.elementType() + "' is already present";
        this.marks.addRule(mark -> allowedClass.isInstance(mark) || !(mark instanceof PositionMark), reason);
    }

    void disableIndentation(ContentNode<?, ? super Paragraph> parent) {
        this.marks.rejectInstancesOf(Indentation.class, parent.elementType());
    }
}

