/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Heading;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.ExpandContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class NestedExpand
extends AbstractContentNode<NestedExpand, NestedExpandContent>
implements ExpandContent,
TableCellContent {
    static final Factory<NestedExpand> FACTORY = new Factory<NestedExpand>("nestedExpand", NestedExpand.class, NestedExpand::parse);
    @Nullable
    private String title;

    private NestedExpand() {
    }

    public static NestedExpand nestedExpand() {
        return new NestedExpand();
    }

    public static NestedExpand nestedExpand(NestedExpandContent content) {
        return (NestedExpand)NestedExpand.nestedExpand().content(content);
    }

    public static NestedExpand nestedExpand(NestedExpandContent ... content) {
        return (NestedExpand)NestedExpand.nestedExpand().content(content);
    }

    public static NestedExpand nestedExpand(Iterable<? extends NestedExpandContent> content) {
        return (NestedExpand)NestedExpand.nestedExpand().content(content);
    }

    public static NestedExpand nestedExpand(Stream<? extends NestedExpandContent> content) {
        return (NestedExpand)NestedExpand.nestedExpand().content(content);
    }

    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    public NestedExpand title(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Override
    public Class<NestedExpandContent> contentClass() {
        return NestedExpandContent.class;
    }

    @Override
    public NestedExpand copy() {
        return NestedExpand.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "nestedExpand";
    }

    @Override
    protected void contentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    protected boolean contentNodeEquals(NestedExpand other) {
        return Objects.equals(this.title, other.title);
    }

    @Override
    protected int contentNodeHashCode() {
        return Objects.hashCode(this.title);
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("title", this.title);
    }

    @Override
    protected void validateContentNodeForAppend(NestedExpandContent node) {
        if (node instanceof Paragraph) {
            ((Paragraph)node).disableMarks(this);
        } else if (node instanceof Heading) {
            ((Heading)node).disableMarks(this);
        } else if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        }
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().add("attrs", FieldMap.map().addIfPresent("title", this.title)).let(this::addContent);
    }

    void disableMarks(ContentNode<?, ? super NestedExpand> parent) {
    }

    private static NestedExpand parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "nestedExpand");
        NestedExpand nestedExpand = (NestedExpand)new NestedExpand().parseRequiredContent(map, NestedExpandContent.class);
        ParserSupport.getOrThrow(map, "attrs");
        ParserSupport.getAttr(map, "title", String.class).ifPresent(nestedExpand::title);
        return nestedExpand;
    }
}

