/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.ctx.Feature;
import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.mark.type.MentionMark;
import com.atlassian.adf.model.node.AbstractMarkedNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.WRONG, date="2023-07-26", comment="the 'accessLevel' attribute is not restricted and an empty string is often used for it")
public class Mention
extends AbstractMarkedNode<Mention, MentionMark>
implements CaptionContent,
InlineContent {
    private static final List<String> MENTION_GLOBAL_IDS = List.of("all", "here");
    private static final String MENTION_UNKNOWN = "@unknown";
    static Factory<Mention> FACTORY = new Factory<Mention>("mention", Mention.class, Mention::parse);
    private String id;
    @Nullable
    private String accessLevel;
    @Nullable
    private String text;
    @Nullable
    private UserType userType;
    @Nullable
    private String localId;

    private Mention(String id) {
        this.id = Mention.validateId(id);
    }

    public static Mention mention(String id) {
        return new Mention(id);
    }

    public Mention id(String id) {
        this.id = Mention.validateId(id);
        return this;
    }

    public String id() {
        return this.id;
    }

    public Optional<String> accessLevel() {
        return Optional.ofNullable(this.accessLevel);
    }

    public Mention accessLevel(@Nullable String accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    public Mention accessLevel(@Nullable AccessLevel accessLevel) {
        this.accessLevel = accessLevel != null ? accessLevel.name() : null;
        return this;
    }

    public Optional<UserType> userType() {
        return Optional.ofNullable(this.userType);
    }

    public Mention userType(@Nullable String userType) {
        if (userType == null || userType.isEmpty()) {
            this.userType = null;
            return this;
        }
        return this.userType(UserType.PARSER.parse(userType));
    }

    public Mention userType(@Nullable UserType userType) {
        this.userType = userType;
        return this;
    }

    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    public Mention localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    public Optional<String> text() {
        return Optional.ofNullable(this.text);
    }

    public Mention text(@Nullable String text) {
        this.text = text == null ? null : (text.isEmpty() ? text : (text.charAt(0) == '@' ? text : "@" + text));
        return this;
    }

    @Override
    protected boolean markedNodeEquals(Mention other) {
        return this.userType == other.userType && this.id.equals(other.id) && Objects.equals(this.accessLevel, other.accessLevel) && Objects.equals(this.text, other.text) && Objects.equals(this.localId, other.localId);
    }

    @Override
    protected int markedNodeHashCode() {
        return Objects.hash(new Object[]{this.accessLevel, this.id, this.text, this.userType, this.localId});
    }

    @Override
    protected void appendMarkedNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendTextField(this.text);
        buf.appendField("id", this.id);
        buf.appendField("accessLevel", this.accessLevel);
        buf.appendField("userType", (Object)this.userType);
        buf.appendField("localId", this.localId);
    }

    @Override
    public Mention copy() {
        return Mention.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "mention";
    }

    @Override
    public Class<MentionMark> markClass() {
        return MentionMark.class;
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().add("id", this.id).addIfPresent("text", this.text).addIfPresent("accessLevel", this.accessLevel).addMappedIfPresent("userType", this.userType, Enum::name).addIfPresent("localId", this.localId)).let(this.marks::addToMap);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        if (MENTION_GLOBAL_IDS.contains(this.id)) {
            sb.append('@').append(this.id);
        } else if (this.text == null || this.text.isEmpty()) {
            if (Feature.PLAINTEXT_MENTION_USE_ID.enabled()) {
                sb.append("@[").append(this.id).append(']');
            } else {
                sb.append(MENTION_UNKNOWN);
            }
        } else {
            sb.append(this.text);
        }
    }

    private static Mention parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "mention");
        String id = (String)ParserSupport.getAttrOrThrow(map, "id");
        Mention mention = new Mention(id);
        ParserSupport.getAttr(map, "text", String.class).ifPresent(mention::text);
        ParserSupport.getAttr(map, "accessLevel", String.class).ifPresent(mention::accessLevel);
        ParserSupport.getAttr(map, "userType", String.class).ifPresent(mention::userType);
        ParserSupport.getAttr(map, "localId", String.class).ifPresent(mention::localId);
        return (Mention)mention.parseMarks(map);
    }

    private static String validateId(String id) {
        return Objects.requireNonNull(id, "id");
    }

    public static enum AccessLevel {
        NONE,
        SITE,
        APPLICATION,
        CONTAINER;

    }

    public static enum UserType {
        DEFAULT,
        SPECIAL,
        APP;

        static EnumParser<UserType> PARSER;

        static {
            PARSER = new EnumParser<UserType>(UserType.class, Enum::name);
        }
    }
}

