/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.MarkKeys;
import com.atlassian.adf.model.mark.type.BodiedExtensionMark;
import com.atlassian.adf.model.mark.type.ExtensionFrameMark;
import com.atlassian.adf.model.mark.type.ExtensionMark;
import com.atlassian.adf.model.mark.type.InlineExtensionMark;
import com.atlassian.adf.model.mark.type.TableMark;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Fragment
extends AbstractMark
implements BodiedExtensionMark,
ExtensionFrameMark,
ExtensionMark,
InlineExtensionMark,
TableMark {
    static final Factory<Fragment> FACTORY = new Factory<Fragment>("fragment", Fragment.class, Fragment::parse);
    private final String localId;
    @Nullable
    private String name;

    private Fragment(String localId) {
        this.localId = Element.nonEmpty(localId, "localId");
    }

    public static Partial.NeedsLocalId fragment() {
        return Partial.NeedsLocalId.INSTANCE;
    }

    public static Fragment fragment(String localId) {
        return new Fragment(localId);
    }

    public String localId() {
        return this.localId;
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Fragment name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Override
    public Fragment copy() {
        return Fragment.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "fragment";
    }

    @Override
    public MarkKey markKey() {
        return MarkKeys.byClassAndId(Fragment.class, this.localId);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().add("localId", this.localId).addIfPresent("name", this.name));
    }

    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof Fragment && this.equalTo((Fragment)o);
    }

    private boolean equalTo(Fragment other) {
        return this.localId.equals(other.localId) && Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hash(this.localId, this.name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.elementType()).append("[localId=").append(this.localId);
        if (this.name != null) {
            sb.append(", name=").append(this.name);
        }
        return sb.append(']').toString();
    }

    private static Fragment parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "fragment");
        Fragment fragment = new Fragment(ParserSupport.getAttrOrThrow(map, "localId", String.class));
        ParserSupport.getAttr(map, "name", String.class).ifPresent(fragment::name);
        return fragment;
    }

    public static interface Partial {

        public static class NeedsLocalId {
            static final NeedsLocalId INSTANCE = new NeedsLocalId();

            private NeedsLocalId() {
            }

            public Fragment localId(String localId) {
                return new Fragment(localId);
            }
        }
    }
}

