/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.mark.AbstractMark;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.model.mark.MarkKeys;
import com.atlassian.adf.model.mark.type.CodeBlockMark;
import com.atlassian.adf.model.mark.type.ExpandMark;
import com.atlassian.adf.model.mark.type.LayoutSectionMark;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Breakout
extends AbstractMark
implements CodeBlockMark,
ExpandMark,
LayoutSectionMark {
    static final MarkKey MARK_KEY = MarkKeys.byClass(Breakout.class);
    static final Factory<Breakout> FACTORY = new Factory<Breakout>("breakout", Breakout.class, Breakout::parse);
    private final Mode mode;
    @Nullable
    private Number width;

    private Breakout(Mode mode) {
        this.mode = mode;
    }

    public static Breakout wide() {
        return new Breakout(Mode.WIDE);
    }

    public static Breakout fullWidth() {
        return new Breakout(Mode.FULL_WIDTH);
    }

    public Mode mode() {
        return this.mode;
    }

    public Optional<Number> width() {
        return Optional.ofNullable(this.width);
    }

    public Breakout width(@Nullable Number width) {
        this.width = width;
        return this;
    }

    @Override
    public Breakout copy() {
        return Breakout.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "breakout";
    }

    @Override
    public MarkKey markKey() {
        return MARK_KEY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Breakout)) {
            return false;
        }
        Breakout other = (Breakout)o;
        return this.mode == other.mode && Objects.equals(this.width, other.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.width});
    }

    @Override
    public Map<String, ?> toMap() {
        FieldMap attrs = FieldMap.map("mode", this.mode.mode()).addIfPresent("width", this.width);
        return this.mapWithType().add("attrs", attrs);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.elementType()).append('[').append((Object)this.mode);
        if (this.width != null) {
            sb.append("; width=").append(this.width);
        }
        return sb.append(']').toString();
    }

    private static Breakout parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "breakout");
        Breakout breakout = Mode.PARSER.parse(ParserSupport.getAttrOrThrow(map, "mode", String.class)).toBreakout();
        ParserSupport.getAttr(map, "width", Number.class).ifPresent(breakout::width);
        return breakout;
    }

    public static enum Mode {
        WIDE("wide", Breakout::wide),
        FULL_WIDTH("full-width", Breakout::fullWidth);

        private final String mode;
        private final Supplier<Breakout> toBreakout;
        static final EnumParser<Mode> PARSER;

        private Mode(String mode, Supplier<Breakout> toBreakout) {
            this.mode = mode;
            this.toBreakout = toBreakout;
        }

        public String mode() {
            return this.mode;
        }

        Breakout toBreakout() {
            return this.toBreakout.get();
        }

        static {
            PARSER = new EnumParser<Mode>(Mode.class, Mode::mode);
        }
    }
}

