/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.ex.node;

import com.atlassian.adf.model.ex.node.NodeException;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class TableCellException
extends NodeException {
    private static final long serialVersionUID = 1L;

    TableCellException(String message) {
        super(message);
    }

    public static class RowspanNotPositive
    extends TableCellException {
        private static final long serialVersionUID = 1L;
        private final int rowspan;

        public RowspanNotPositive(int rowspan) {
            super("Value for 'rowspan' must be positive: " + rowspan);
            this.rowspan = rowspan;
            if (rowspan > 0) {
                throw new IllegalArgumentException("Exception should only be thrown for a zero or a negative value: " + rowspan);
            }
        }

        public int rowspan() {
            return this.rowspan;
        }
    }

    public static class ColspanNotPositive
    extends TableCellException {
        private static final long serialVersionUID = 1L;
        private final int colspan;

        public ColspanNotPositive(int colspan) {
            super("Value for 'colspan' must be positive: " + colspan);
            this.colspan = colspan;
            if (colspan > 0) {
                throw new IllegalArgumentException("Exception should only be thrown for a non-positive value: " + colspan);
            }
        }

        public int colspan() {
            return this.colspan;
        }
    }

    public static class ColwidthDoesNotMatchColspan
    extends ColwidthException {
        private static final long serialVersionUID = 1L;
        @Nullable
        private final Integer colspan;
        private final int colwidthLength;

        public ColwidthDoesNotMatchColspan(@Nullable Integer colspan, int[] colwidth) {
            this(colspan, Objects.requireNonNull(colwidth, "colwidth").length);
        }

        private ColwidthDoesNotMatchColspan(@Nullable Integer colspan, int colwidthLength) {
            super("The 'colwidth' must contain exactly 'colspan' values, or exactly 1 value if it is not specified: colspan=" + colspan + "; colwidth.length=" + colwidthLength);
            int expectedLength;
            this.colspan = colspan;
            this.colwidthLength = colwidthLength;
            int n = expectedLength = colspan != null ? colspan : 1;
            if (colwidthLength == expectedLength) {
                throw new IllegalArgumentException("This should only be called when colspan=" + colspan + " and colwidth.length=" + colwidthLength + " do not match");
            }
        }

        @Nullable
        public Integer colspan() {
            return this.colspan;
        }

        public int expectedLength() {
            return this.colspan != null ? this.colspan : 1;
        }

        public int colwidthLength() {
            return this.colwidthLength;
        }
    }

    public static class ColwidthMustHaveAtLeastOnePositiveValue
    extends ColwidthException {
        private static final long serialVersionUID = 1L;

        public ColwidthMustHaveAtLeastOnePositiveValue() {
            super("The column width attribute 'colwidth' must contain at least one positive value");
        }
    }

    public static class ColwidthCannotBeNegative
    extends ColwidthException {
        private static final long serialVersionUID = 1L;
        private final int index;
        private final int value;

        public ColwidthCannotBeNegative(int index, int value) {
            super("Value at colwidth[" + index + "] cannot be negative: " + value);
            this.index = index;
            this.value = value;
            if (index < 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            if (value >= 0) {
                throw new IllegalArgumentException("Exception should only be thrown for a negative value: " + value);
            }
        }

        public int index() {
            return this.index;
        }

        public int value() {
            return this.value;
        }
    }

    public static abstract class ColwidthException
    extends TableCellException {
        private static final long serialVersionUID = 1L;

        ColwidthException(String message) {
            super(message);
        }
    }
}

