/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.ex.mark;

import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.mark.Mark;
import com.atlassian.annotations.Internal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class MarkException
extends AdfException {
    private static final long serialVersionUID = 1L;

    MarkException(String message) {
        super(message);
    }

    public static class LimitReached
    extends ConstraintViolation {
        private static final long serialVersionUID = 1L;
        private final int limit;
        private final List<String> markTypes;

        @Internal
        public LimitReached(int limit, Collection<String> markTypes) {
            super("mark limit reached: " + limit + ": " + String.valueOf(markTypes));
            this.limit = limit;
            this.markTypes = List.copyOf(markTypes);
        }

        public int limit() {
            return this.limit;
        }

        public List<String> markTypes() {
            return this.markTypes;
        }
    }

    public static class DuplicateMarkType
    extends ConstraintViolation {
        private static final long serialVersionUID = 1L;
        private final String markType;

        @Internal
        public DuplicateMarkType(Mark mark) {
            this(mark.elementType());
        }

        @Internal
        public DuplicateMarkType(String markType) {
            super("duplicate mark type: " + markType);
            this.markType = Objects.requireNonNull(markType, "markType");
        }

        public String markType() {
            return this.markType;
        }
    }

    public static class MarkDisallowed
    extends ConstraintViolation {
        private static final long serialVersionUID = 1L;
        private final String reason;
        private final String markType;

        @Internal
        public MarkDisallowed(String reason, Mark mark) {
            this(reason, mark.elementType());
        }

        @Internal
        public MarkDisallowed(String reason, String markType) {
            super(reason + ": " + markType);
            this.reason = Objects.requireNonNull(reason, "reason");
            this.markType = Objects.requireNonNull(markType, "markType");
        }

        public String reason() {
            return this.reason;
        }

        public String markType() {
            return this.markType;
        }
    }

    public static class RestrictedMarkAlreadyPresent
    extends ConstraintViolation {
        private static final long serialVersionUID = 1L;
        private final String reason;
        private final List<String> markTypes;

        @Internal
        public RestrictedMarkAlreadyPresent(String reason, Collection<String> markTypes) {
            super(reason + ": marks already present: " + String.valueOf(markTypes));
            this.reason = Objects.requireNonNull(reason, "reason");
            this.markTypes = List.copyOf(markTypes);
            if (this.markTypes.isEmpty()) {
                throw new IllegalArgumentException("markTypes should not have been empty");
            }
        }

        public String reason() {
            return this.reason;
        }

        public List<String> markTypes() {
            return this.markTypes;
        }
    }

    public static abstract class ConstraintViolation
    extends MarkException {
        private static final long serialVersionUID = 1L;

        @Internal
        public ConstraintViolation(String message) {
            super(message);
        }
    }

    public static class TypeUnsupported
    extends MarkException {
        private static final long serialVersionUID = 1L;
        private final Class<? extends Mark> expectedMarkClass;
        private final String type;

        @Internal
        public TypeUnsupported(Class<? extends Mark> expectedMarkClass, String type) {
            super("Cannot accept unsupported mark '" + type + "' as " + expectedMarkClass.getName());
            this.expectedMarkClass = Objects.requireNonNull(expectedMarkClass, "expectedMarkClass");
            this.type = Objects.requireNonNull(type, "type");
        }

        public Class<? extends Mark> expectedMarkClass() {
            return this.expectedMarkClass;
        }

        public String type() {
            return this.type;
        }
    }

    public static class TypeMismatch
    extends MarkException {
        private static final long serialVersionUID = 1L;
        private final Class<? extends Mark> expectedMarkClass;
        private final String type;

        @Internal
        public TypeMismatch(Class<? extends Mark> expectedMarkClass, String type) {
            super("Cannot accept mark '" + type + "' as " + expectedMarkClass.getName());
            this.expectedMarkClass = Objects.requireNonNull(expectedMarkClass, "expectedMarkClass");
            this.type = Objects.requireNonNull(type, "type");
        }

        public Class<? extends Mark> expectedMarkClass() {
            return this.expectedMarkClass;
        }

        public String type() {
            return this.type;
        }
    }
}

