/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node.type;

import com.atlassian.adf.model.node.Node;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ContentNode<C extends ContentNode<C, N>, N extends Node>
extends Node {
    public C copy();

    public Class<N> contentClass();

    public boolean isEmpty();

    public List<N> content();

    public C content(N var1);

    public C content(N ... var1);

    public C content(Iterable<? extends N> var1);

    public C content(Stream<? extends N> var1);

    public Stream<Node> allNodes();

    public C clear();

    public Map<String, ?> toMapWithEmptyContent();

    public void removeIf(Predicate<? super N> var1);

    public void replaceContent(List<? extends N> var1);

    default public <T extends Node> Stream<T> allNodesOfType(Class<T> nodeClass) {
        return this.allNodes().filter(nodeClass::isInstance).map(nodeClass::cast);
    }

    default public <T extends Node> List<T> allNodesOfTypeAsList(Class<T> nodeClass) {
        return this.allNodesOfType(nodeClass).collect(Collectors.toList());
    }

    public void transformContent(Function<? super N, ? extends N> var1);

    public <T extends Node> void transformDescendants(Class<T> var1, Function<? super T, ? extends T> var2);

    public <T extends Node> List<MatchContainer<T>> findMatchingDescendants(Class<T> var1, Predicate<? super T> var2);

    public C contentWithMarkValidation(Iterable<? extends N> var1);

    public record Match<N extends Node>(int index, N match) {
        public Match {
            if (index < 0) {
                throw new IndexOutOfBoundsException(index);
            }
            Objects.requireNonNull(match, "match");
        }
    }

    public record MatchContainer<N extends Node>(Node parent, List<Match<N>> children) {
        public MatchContainer {
            Objects.requireNonNull(parent, "parent");
            Objects.requireNonNull(children, "children");
            if (children.isEmpty()) {
                throw new IllegalArgumentException("children is empty");
            }
        }
    }
}

