/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.mark.MarkException;
import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.model.mark.MarkKey;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.FieldMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class MarkHolder<M extends Mark> {
    private static final PermanentRule<Object> DISABLE_PERMANENTLY = mark -> false;
    private static final Map<?, ?> EMPTY_MAP = Collections.emptyMap();
    private Map<MarkKey, M> marks = (Map)Cast.unsafeCast(EMPTY_MAP);
    private Map<String, Predicate<? super M>> rules = (Map)Cast.unsafeCast(EMPTY_MAP);
    private final int limit;

    private MarkHolder(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit cannot be negative: " + limit);
        }
        this.limit = limit;
    }

    static <M extends Mark> MarkHolder<M> unlimited() {
        return new MarkHolder<M>(Integer.MAX_VALUE);
    }

    static <M extends Mark> MarkHolder<M> limit(int limit) {
        return new MarkHolder<M>(limit);
    }

    void add(M mark) {
        AdfException.frame("." + mark.elementType(), () -> {
            Supplier err = this.addIfAllowed(mark).orElse(null);
            if (err != null) {
                throw (AdfException)err.get();
            }
            return null;
        });
    }

    Optional<Supplier<? extends MarkException.ConstraintViolation>> addIfAllowed(M mark) {
        if (this.size() >= this.limit) {
            return Optional.of(() -> new MarkException.LimitReached(this.limit, this.getTypes()));
        }
        for (Map.Entry<String, Predicate<M>> entry : this.rules.entrySet()) {
            Predicate<M> rule = entry.getValue();
            if (rule.test(mark)) continue;
            String reason = entry.getKey();
            return Optional.of(() -> new MarkException.MarkDisallowed(reason, (Mark)mark));
        }
        Mark existing = (Mark)this.mutableMarks().putIfAbsent(mark.markKey(), mark);
        if (existing != null) {
            return Optional.of(() -> new MarkException.DuplicateMarkType((Mark)mark));
        }
        return Optional.empty();
    }

    Collection<M> get() {
        return Collections.unmodifiableCollection(this.marks.values());
    }

    Set<String> getTypes() {
        LinkedHashSet<String> set = new LinkedHashSet<String>(this.marks.size());
        for (Mark mark : this.marks.values()) {
            set.add(mark.elementType());
        }
        return Collections.unmodifiableSet(set);
    }

    boolean containsMark(M mark) {
        return mark.equals(this.marks.get(mark.markKey()));
    }

    @Deprecated
    Optional<M> findFirst(String markType) {
        return this.marks.values().stream().filter(mark -> mark.elementType().equals(markType)).findFirst();
    }

    Optional<M> get(MarkKey markKey) {
        return Optional.ofNullable((Mark)this.marks.get(markKey));
    }

    Optional<M> remove(MarkKey markKey) {
        return Optional.ofNullable((Mark)this.marks.remove(markKey));
    }

    boolean removeAll(Class<? extends M> markClass) {
        return this.marks.values().removeIf(markClass::isInstance);
    }

    boolean removeAll(String markType) {
        return this.marks.values().removeIf(mark -> mark.elementType().equals(markType));
    }

    Stream<M> stream(String markType) {
        return this.marks.values().stream().filter(mark -> mark.elementType().equals(markType));
    }

    <T extends M> Stream<T> stream(Class<T> markClass) {
        return this.marks.values().stream().filter(markClass::isInstance).map(markClass::cast);
    }

    private Map<String, Predicate<? super M>> mutableRules() {
        Map<String, Predicate<M>> rules = this.rules;
        if (rules == EMPTY_MAP) {
            rules = new LinkedHashMap<String, Predicate<? super M>>();
            this.rules = rules;
        }
        return rules;
    }

    private Map<MarkKey, M> mutableMarks() {
        Map<MarkKey, M> marks = this.marks;
        if (marks == EMPTY_MAP) {
            this.marks = marks = new LinkedHashMap<MarkKey, M>();
        }
        return marks;
    }

    void disable(String reason) {
        if (!this.marks.isEmpty()) {
            throw new MarkException.RestrictedMarkAlreadyPresent(reason, this.getTypes());
        }
        Map<String, Predicate<M>> rules = this.mutableRules();
        if (rules.put(reason, DISABLE_PERMANENTLY) == null && rules.size() > 1) {
            rules.keySet().removeIf(key -> !key.equals(reason));
        }
    }

    void restrictToInstancesOf(Class<? extends Mark> cls, String reason) {
        this.addRule(cls::isInstance, reason);
    }

    void addRule(Predicate<? super M> rule, String reason) {
        this.validateRule(reason, rule);
        this.mutableRules().put(reason, rule);
    }

    void validate() {
        this.rules.forEach(this::validateRule);
    }

    private void validateRule(String reason, Predicate<? super M> rule) {
        Map<MarkKey, M> marks = this.marks;
        for (Mark mark : marks.values()) {
            if (rule.test(mark)) continue;
            throw new MarkException.MarkDisallowed(reason, mark);
        }
    }

    List<Map<String, ?>> toListOfMaps() {
        if (this.marks.isEmpty()) {
            return List.of();
        }
        return this.marks.values().stream().map(Element::toMap).collect(Collectors.toList());
    }

    void addToMap(FieldMap map) {
        if (!this.marks.isEmpty()) {
            map.put("marks", this.toListOfMaps());
        }
    }

    boolean isEmpty() {
        return this.marks.isEmpty();
    }

    int size() {
        return this.marks.size();
    }

    boolean clear() {
        boolean modified = !this.marks.isEmpty();
        this.marks = (Map)Cast.unsafeCast(EMPTY_MAP);
        Map<String, Predicate<M>> rules = this.rules;
        if (!rules.isEmpty()) {
            rules.values().removeIf(rule -> !(rule instanceof PermanentRule));
        }
        return modified;
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof MarkHolder && ((MarkHolder)o).marks.equals(this.marks);
    }

    public int hashCode() {
        return this.marks.hashCode();
    }

    public String toString() {
        return "MarkHolder" + String.valueOf(this.marks.values());
    }

    public static <T> Predicate<T> permanentRule(Predicate<T> delegate) {
        return PermanentRule.wrap(delegate);
    }

    private static interface PermanentRule<T>
    extends Predicate<T> {
        public static <T> PermanentRule<T> wrap(Predicate<T> delegate) {
            Objects.requireNonNull(delegate, "delegate");
            return delegate::test;
        }
    }
}

