/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.mark.type.DateMark;
import com.atlassian.adf.model.node.AbstractMarkedNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.DateUtil;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Date
extends AbstractMarkedNode<Date, DateMark>
implements LocalIdOptional<Date>,
CaptionContent,
InlineContent {
    static final Factory<Date> FACTORY = new Factory<Date>("date", Date.class, Date::parse);
    private String timestamp;
    @Nullable
    private String localId;

    private Date(String timestamp) {
        this.timestamp = Date.validateTimestamp(timestamp);
    }

    public static Partial.NeedsTimestamp date() {
        return new Partial.NeedsTimestamp();
    }

    public static Date date(String timestamp) {
        return new Date(timestamp);
    }

    public static Date date(long epochMillis) {
        return Date.date(Instant.ofEpochMilli(epochMillis));
    }

    public static Date date(Instant instant) {
        return new Date(instant.toString());
    }

    public static Date date(java.util.Date date) {
        return Date.date(date.getTime());
    }

    public Date timestamp(String timestamp) {
        this.timestamp = Date.validateTimestamp(timestamp);
        return this;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Override
    public Date localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    @Override
    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    @Override
    public String elementType() {
        return "date";
    }

    @Override
    public Class<DateMark> markClass() {
        return DateMark.class;
    }

    @Override
    public Date copy() {
        return Date.parse(this.toMap());
    }

    @Override
    protected boolean markedNodeEquals(Date other) {
        return this.timestamp.equals(other.timestamp) && Objects.equals(this.localId, other.localId);
    }

    @Override
    protected int markedNodeHashCode() {
        return Objects.hash(this.timestamp, this.localId);
    }

    @Override
    protected void appendMarkedNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
        buf.appendField("timestamp", this.timestamp);
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map("timestamp", this.timestamp).addIfPresent("localId", this.localId)).let(this.marks::addToMap);
    }

    private static Date parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "date");
        String timestamp = (String)ParserSupport.getAttrOrThrow(map, "timestamp");
        Date date = (Date)Date.date(timestamp).parseMarks(map);
        LocalIdOptional.parseLocalId(date, map);
        return date;
    }

    private static String validateTimestamp(String timestamp) {
        return Element.nonEmpty(timestamp, "timestamp");
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        sb.append(DateUtil.timestampToIsoFormat(this.timestamp));
    }

    public static interface Partial {

        public static class NeedsTimestamp {
            NeedsTimestamp() {
            }

            public Date timestamp(String timestamp) {
                return new Date(timestamp);
            }
        }
    }
}

