/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.LocalIdOptional;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.BlockquoteContent;
import com.atlassian.adf.model.node.type.BodiedSyncBlockContent;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.ExtensionFrameContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Blockquote
extends AbstractContentNode<Blockquote, BlockquoteContent>
implements LocalIdOptional<Blockquote>,
BodiedSyncBlockContent,
DocContent,
ExtensionFrameContent,
LayoutColumnContent,
NestedExpandContent,
NonNestableBlockContent,
TableCellContent {
    static final Factory<Blockquote> FACTORY = new Factory<Blockquote>("blockquote", Blockquote.class, Blockquote::parse);
    @Nullable
    private String localId;

    private Blockquote() {
    }

    @Override
    public Class<BlockquoteContent> contentClass() {
        return BlockquoteContent.class;
    }

    public static Blockquote bq() {
        return new Blockquote();
    }

    public static Blockquote bq(String content) {
        return (Blockquote)Blockquote.bq().content(Paragraph.p(content));
    }

    public static Blockquote bq(String ... content) {
        return (Blockquote)Blockquote.bq().content(Arrays.stream(content).map(Text::text).map(Paragraph::p));
    }

    public static Blockquote bq(Paragraph content) {
        return (Blockquote)Blockquote.bq().content(content);
    }

    public static Blockquote bq(BlockquoteContent ... content) {
        return (Blockquote)Blockquote.bq().content(content);
    }

    public static Blockquote bq(Iterable<? extends BlockquoteContent> content) {
        return (Blockquote)Blockquote.bq().content(content);
    }

    public static Blockquote bq(Stream<? extends BlockquoteContent> content) {
        return (Blockquote)Blockquote.bq().content(content);
    }

    public static Blockquote blockquote() {
        return new Blockquote();
    }

    public static Blockquote blockquote(String content) {
        return Blockquote.bq(content);
    }

    public static Blockquote blockquote(String ... content) {
        return Blockquote.bq(content);
    }

    public static Blockquote blockquote(BlockquoteContent content) {
        return Blockquote.bq(content);
    }

    public static Blockquote blockquote(BlockquoteContent ... content) {
        return Blockquote.bq(content);
    }

    public static Blockquote blockquote(Iterable<? extends BlockquoteContent> content) {
        return Blockquote.bq(content);
    }

    public static Blockquote blockquote(Stream<? extends BlockquoteContent> content) {
        return Blockquote.bq(content);
    }

    @Override
    public Blockquote localId(@Nullable String localId) {
        this.localId = localId;
        return this;
    }

    @Override
    public Optional<String> localId() {
        return Optional.ofNullable(this.localId);
    }

    @Override
    public Blockquote copy() {
        return Blockquote.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "blockquote";
    }

    @Override
    protected void contentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    protected void validateContentNodeForAppend(BlockquoteContent node) {
        if (node instanceof Paragraph) {
            ((Paragraph)node).disableMarks(this);
        } else if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        }
    }

    @Override
    protected int contentNodeHashCode() {
        return Objects.hashCode(this.localId);
    }

    @Override
    protected boolean contentNodeEquals(Blockquote other) {
        return Objects.equals(this.localId, other.localId);
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().let(this::addContent).addIf(this.localId != null, "attrs", () -> FieldMap.map("localId", this.localId));
    }

    private static Blockquote parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "blockquote");
        Blockquote bq = (Blockquote)Blockquote.bq().parseRequiredContent(map, BlockquoteContent.class);
        LocalIdOptional.parseLocalId(bq, map);
        return bq;
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        sb.append("> ");
        this.content.forEach(child -> child.appendPlainText(sb));
    }
}

