/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.LocalIdRequired;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.BlockTaskItemContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.model.node.type.TaskListContent;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2025-08-01")
public class BlockTaskItem
extends AbstractContentNode<BlockTaskItem, BlockTaskItemContent>
implements LocalIdRequired<BlockTaskItem>,
TaskListContent {
    private static final String PREFIX_DONE = "[x] ";
    private static final String PREFIX_TODO = "[] ";
    static final Factory<BlockTaskItem> FACTORY = new Factory<BlockTaskItem>("blockTaskItem", BlockTaskItem.class, BlockTaskItem::parse);
    private String localId;
    private State state;

    private BlockTaskItem(String localId, State state) {
        this.localId = Objects.requireNonNull(localId, "localId");
        this.state = Objects.requireNonNull(state, "state");
    }

    private BlockTaskItem(UUID localId, State state) {
        this(Objects.requireNonNull(localId, "localId").toString(), state);
    }

    public static Partial.NeedsLocalIdAndState blockTaskItem() {
        return new Partial.NeedsLocalIdAndState();
    }

    public static BlockTaskItem todo(String localId) {
        return new BlockTaskItem(localId, State.TODO);
    }

    public static BlockTaskItem done(String localId) {
        return new BlockTaskItem(localId, State.DONE);
    }

    public static BlockTaskItem todo(UUID localId) {
        return new BlockTaskItem(localId, State.TODO);
    }

    public static BlockTaskItem done(UUID localId) {
        return new BlockTaskItem(localId, State.DONE);
    }

    @Override
    public BlockTaskItem content(String content) {
        return (BlockTaskItem)this.content(Paragraph.p((InlineContent)Text.text(content)));
    }

    @Override
    public BlockTaskItem content(String ... content) {
        return (BlockTaskItem)this.content(Paragraph.p(Text.text(content)));
    }

    @Override
    public BlockTaskItem localId(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        return this;
    }

    @Override
    public String localId() {
        return this.localId;
    }

    public BlockTaskItem state(State state) {
        this.state = Objects.requireNonNull(state, "state");
        return this;
    }

    public State state() {
        return this.state;
    }

    public BlockTaskItem todo() {
        return this.state(State.TODO);
    }

    public BlockTaskItem done() {
        return this.state(State.DONE);
    }

    @Override
    public Class<BlockTaskItemContent> contentClass() {
        return BlockTaskItemContent.class;
    }

    @Override
    public BlockTaskItem copy() {
        return BlockTaskItem.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "blockTaskItem";
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().let(this::addContentIfPresent).add("attrs", FieldMap.map().add("localId", this.localId).add("state", this.state.name()));
    }

    @Override
    protected boolean contentNodeEquals(BlockTaskItem other) {
        return this.localId.equals(other.localId) && this.state.equals((Object)other.state);
    }

    @Override
    protected int contentNodeHashCode() {
        return Objects.hash(new Object[]{this.localId, this.state});
    }

    @Override
    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("localId", this.localId);
        buf.appendField("state", (Object)this.state);
    }

    @Override
    protected void contentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    protected void validateContentNodeForAppend(BlockTaskItemContent node) {
        super.validateContentNodeForAppend(node);
        if (node instanceof Paragraph) {
            Paragraph paragraph = (Paragraph)node;
            paragraph.disableMarks(this);
        }
    }

    public static BlockTaskItem parse(Map<String, ?> map) {
        String localId = LocalIdRequired.parseLocalId(map);
        State state = State.PARSER.parse((String)ParserSupport.getAttrOrThrow(map, "state"));
        return (BlockTaskItem)new BlockTaskItem(localId, state).parseRequiredContent(map, BlockTaskItemContent.class);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        String prefix = this.state == State.DONE ? PREFIX_DONE : PREFIX_TODO;
        sb.append(prefix);
        this.appendPlainTextInlineContent(sb);
    }

    public static enum State {
        TODO,
        DONE;

        static final EnumParser<State> PARSER;

        static {
            PARSER = new EnumParser<State>(State.class, Enum::name);
        }
    }

    public static interface Partial {

        public static class NeedsLocalIdAndState {
            NeedsLocalIdAndState() {
            }

            public NeedsState localId(String localId) {
                return new NeedsState(localId);
            }

            public NeedsState localId(UUID localId) {
                return this.localId(Objects.requireNonNull(localId, "localId").toString());
            }

            public NeedsLocalId state(String state) {
                return this.state(State.PARSER.parse(state));
            }

            public NeedsLocalId state(State state) {
                return new NeedsLocalId(state);
            }

            public NeedsLocalId todo() {
                return this.state(State.TODO);
            }

            public NeedsLocalId done() {
                return this.state(State.DONE);
            }
        }

        public static class NeedsLocalId {
            private final State state;

            NeedsLocalId(State state) {
                this.state = Objects.requireNonNull(state, "state");
            }

            public BlockTaskItem localId(String localId) {
                return new BlockTaskItem(localId, this.state);
            }

            public BlockTaskItem localId(UUID localId) {
                return this.localId(Objects.requireNonNull(localId, "localId").toString());
            }
        }

        public static class NeedsState {
            private final String localId;

            NeedsState(String localId) {
                this.localId = Objects.requireNonNull(localId, "localId");
            }

            public BlockTaskItem state(String state) {
                Objects.requireNonNull(state, "state");
                return this.state(State.PARSER.parse(state));
            }

            public BlockTaskItem state(State state) {
                Objects.requireNonNull(state, "state");
                return new BlockTaskItem(this.localId, state);
            }

            public BlockTaskItem todo() {
                return this.state(State.TODO);
            }

            public BlockTaskItem done() {
                return this.state(State.DONE);
            }
        }
    }
}

