/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.ctx;

import com.atlassian.adf.ctx.Feature;
import com.atlassian.adf.ctx.FeatureProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FeatureSet
implements FeatureProvider {
    private final Map<Feature, Boolean> features;

    private FeatureSet(Map<Feature, Boolean> features) {
        this.features = Map.copyOf(features);
    }

    public static FeatureSet of(Feature ... features) {
        Builder builder = FeatureSet.builder();
        for (Feature feature : features) {
            builder.enable(feature);
        }
        return builder.build();
    }

    @Override
    public FeatureSet withOverrides(FeatureSet overrides) {
        return this.copy().putAll(overrides).build();
    }

    public boolean enabled(Feature feature, FeatureProvider delegate) {
        Objects.requireNonNull(feature, "feature");
        Objects.requireNonNull(delegate, "delegate");
        Boolean value = this.features.get((Object)feature);
        return value != null ? value.booleanValue() : delegate.enabled(feature);
    }

    @Override
    public boolean enabled(Feature feature) {
        return this.enabled(feature, Feature::defaultToEnabled);
    }

    public Builder copy() {
        Builder builder = new Builder();
        builder.features.putAll(this.features);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static class Builder {
        private final Map<Feature, Boolean> features = new HashMap<Feature, Boolean>();

        Builder() {
        }

        public Builder enable(Feature feature) {
            return this.set(feature, true);
        }

        public Builder disable(Feature feature) {
            return this.set(feature, false);
        }

        public Builder set(Feature feature, boolean enabled) {
            Objects.requireNonNull(feature, "feature");
            this.features.put(feature, enabled);
            return this;
        }

        public Builder putAll(FeatureSet featureSet) {
            featureSet.features.forEach(this::set);
            return this;
        }

        public FeatureSet build() {
            return new FeatureSet(this.features);
        }
    }
}

