/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.parser.HtmlParser;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.util.Char;
import java.util.stream.Stream;
import org.jsoup.nodes.TextNode;

class TextParser {
    TextParser() {
    }

    static Stream<Text> parseText(HtmlParser htmlParser, TextNode html) {
        String text = htmlParser.keepWhitespace() ? html.getWholeText() : TextParser.collapseWhitespace(html);
        return Stream.of(text).filter(s -> !s.isEmpty()).map(Text::text);
    }

    private static String collapseWhitespace(TextNode html) {
        String raw = html.getWholeText();
        if (raw.indexOf(160) == -1) {
            return html.text();
        }
        for (int i = 0; i < raw.length(); ++i) {
            if (!Char.isSpace((char)raw.charAt(i))) continue;
            return new CollapseWhitespace(raw, i).process();
        }
        return raw;
    }

    static class CollapseWhitespace {
        private final String raw;
        private final StringBuilder sb;
        private int mark = -1;
        private int pos;

        CollapseWhitespace(String raw, int firstSpace) {
            this.raw = raw;
            this.sb = new StringBuilder(raw.length());
            this.pos = firstSpace;
        }

        String process() {
            if (this.pos > 0) {
                this.sb.append(this.raw, 0, this.pos);
            }
            int len = this.raw.length();
            while (++this.pos < len) {
                if (Char.isSpace((char)this.raw.charAt(this.pos))) {
                    if (this.mark == -1) continue;
                    this.sb.append(this.raw, this.mark, this.pos);
                    this.mark = -1;
                    continue;
                }
                if (this.mark != -1) continue;
                this.sb.append(' ');
                this.mark = this.pos;
            }
            if (this.mark >= 0) {
                this.sb.append(this.raw, this.mark, len);
            }
            return this.sb.toString();
        }
    }
}

