/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.parser.CodeBlockParser;
import com.atlassian.adf.html.parser.ElementParser;
import com.atlassian.adf.html.parser.HtmlParser;
import com.atlassian.adf.model.mark.Code;
import com.atlassian.adf.model.mark.Em;
import com.atlassian.adf.model.mark.Strike;
import com.atlassian.adf.model.mark.Strong;
import com.atlassian.adf.model.mark.SubSup;
import com.atlassian.adf.model.mark.Underline;
import com.atlassian.adf.model.mark.type.TextMark;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.util.Cast;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jsoup.nodes.Element;

class TextMarkParser
implements ElementParser {
    static final TextMarkParser CODE = new TextMarkParser(Code::code){

        @Override
        public Stream<? extends Node> parse(HtmlParser htmlParser, Element html) {
            CodeBlockParser.getLanguage(html).ifPresent(htmlParser.languageCallback());
            return super.parse(htmlParser, html);
        }
    };
    static final TextMarkParser CODE_WITHOUT_LANG = new TextMarkParser(Code::code);
    static final TextMarkParser EM = new TextMarkParser(Em::em);
    static final TextMarkParser STRIKE = new TextMarkParser(Strike::strike);
    static final TextMarkParser STRONG = new TextMarkParser(Strong::strong);
    static final TextMarkParser SUB = new TextMarkParser(SubSup::sub);
    static final TextMarkParser SUP = new TextMarkParser(SubSup::sup);
    static final TextMarkParser UNDERLINE = new TextMarkParser(Underline::underline);
    private final Supplier<TextMark> markFactory;

    TextMarkParser(Supplier<TextMark> markFactory) {
        this.markFactory = markFactory;
    }

    @Override
    public Stream<? extends Node> parse(HtmlParser htmlParser, Element html) {
        return this.decorate(htmlParser.parseChildren((org.jsoup.nodes.Node)html));
    }

    Stream<? extends Node> decorate(Stream<? extends Node> children) {
        return TextMarkParser.decorate(children, this.markFactory);
    }

    static Stream<? extends Node> decorate(Stream<? extends Node> children, Supplier<TextMark> markFactory) {
        return children.peek(node -> TextMarkParser.decorate(node, markFactory));
    }

    static void decorate(Node node, Supplier<TextMark> markFactory) {
        if (node instanceof Text) {
            Text text = (Text)node;
            text.markIfAllowed(markFactory.get());
        } else if (node instanceof ContentNode) {
            ContentNode contentNode = (ContentNode)Cast.unsafeCast((Object)node);
            for (Node child : contentNode.content()) {
                TextMarkParser.decorate(child, markFactory);
            }
        }
    }
}

