/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.parser.BlockParser;
import com.atlassian.adf.html.parser.ElementParser;
import com.atlassian.adf.html.parser.HtmlParser;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.OrderedList;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jsoup.nodes.Element;

class OrderedListParser
implements ElementParser {
    static final OrderedListParser INSTANCE = new OrderedListParser();

    private OrderedListParser() {
    }

    @Override
    public Stream<? extends Node> parse(HtmlParser htmlParser, Element html) {
        OrderedListSupplier factory = new OrderedListSupplier();
        String start = html.attributes().get("start");
        if (!start.isEmpty()) {
            try {
                int parsedStart = Integer.parseInt(start);
                if (parsedStart >= 0) {
                    factory.order(parsedStart);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return BlockParser.parseBlock(htmlParser, html, factory);
    }

    static class OrderedListSupplier
    implements Supplier<OrderedList> {
        @Nullable
        private OrderedList prev;
        private int order = 1;

        OrderedListSupplier() {
        }

        void order(int order) {
            this.order = order;
        }

        @Override
        public OrderedList get() {
            if (this.prev != null) {
                this.order += this.prev.content().size();
            }
            this.prev = OrderedList.ol((int)this.order);
            return this.prev;
        }
    }
}

