/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.ex.HtmlException;
import com.atlassian.adf.html.parser.BlockParser;
import com.atlassian.adf.html.parser.HtmlParser;
import com.atlassian.adf.model.node.Doc;
import com.atlassian.adf.model.node.ListItem;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.InlineContent;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

class HtmlConverter {
    static final HtmlConverter INSTANCE = new HtmlConverter();

    private HtmlConverter() {
    }

    Doc unmarshall(HtmlParser htmlParser, String html) {
        return this.toAdf(htmlParser, this.parse(html));
    }

    Doc toAdf(HtmlParser htmlParser, Document html) {
        Element body = Objects.requireNonNull(html.body(), "body");
        Doc doc = this.toAdf(BlockParser.parseBlock(htmlParser, body, Doc::doc));
        doc.validate();
        return doc;
    }

    private Doc toAdf(Stream<? extends Node> contents) {
        Node first;
        List<Node> blocks = contents.collect(Collectors.toList());
        if (blocks.isEmpty()) {
            return Doc.doc();
        }
        if (blocks.size() == 1 && (first = (Node)blocks.get(0)) instanceof Doc) {
            return (Doc)first;
        }
        Doc doc = Doc.doc();
        blocks.forEach(node -> this.add(doc, (Node)node));
        return doc;
    }

    private void add(Doc doc, Node node) {
        if (node instanceof Doc) {
            Doc other = (Doc)node;
            doc.content((Iterable)other.content());
        } else if (node instanceof DocContent) {
            doc.content((Node)((DocContent)node));
        } else if (node instanceof ListItem) {
            ListItem li = (ListItem)node;
            li.content().forEach(lic -> this.add(doc, (Node)lic));
        } else if (node instanceof InlineContent) {
            Paragraph p = Paragraph.p((InlineContent)((InlineContent)node));
            doc.content((Node)p);
        } else {
            throw new HtmlException.HtmlStructureException("doc", DocContent.class, node);
        }
    }

    private Document parse(String value) {
        try {
            return Objects.requireNonNull(Jsoup.parseBodyFragment((String)value), "html");
        }
        catch (Exception e) {
            throw new HtmlException.HtmlParseException(e);
        }
    }
}

