/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.parser.ChildrenParser;
import com.atlassian.adf.html.parser.ElementParser;
import com.atlassian.adf.html.parser.HtmlParser;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jsoup.nodes.Element;

class CodeBlockParser
implements ElementParser {
    private static final Pattern LANGUAGE_REGEX = Pattern.compile("\\blanguage-(\\S+)\\b");
    static final CodeBlockParser INSTANCE = new CodeBlockParser();

    private CodeBlockParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<? extends Node> parse(HtmlParser htmlParser, Element html) {
        boolean savedKeepWhitespace = htmlParser.keepWhitespace();
        Consumer<String> savedLanguageCallback = htmlParser.languageCallback();
        Builder builder = new Builder(htmlParser, html);
        try {
            htmlParser.keepWhitespace(true).languageCallback(language -> {
                builder.language = language;
            });
            Stream<? extends Node> stream = builder.build();
            return stream;
        }
        finally {
            htmlParser.keepWhitespace(savedKeepWhitespace).languageCallback(savedLanguageCallback);
        }
    }

    static Optional<String> getLanguage(Element html) {
        String className = html.className();
        if (className.isEmpty()) {
            return Optional.empty();
        }
        Matcher matcher = LANGUAGE_REGEX.matcher(className);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    static class Builder {
        private final List<Node> output = new ArrayList<Node>();
        private final HtmlParser htmlParser;
        private final Element html;
        @Nullable
        private String language;
        @Nullable
        private String firstText;
        @Nullable
        private StringBuilder buf;

        Builder(HtmlParser htmlParser, Element html) {
            this.htmlParser = htmlParser;
            this.html = html;
            this.language = CodeBlockParser.getLanguage(html).orElse(null);
        }

        Stream<? extends Node> build() {
            ChildrenParser.parseChildren(this.htmlParser, this.html).forEach(this::addNode);
            this.flushContent();
            return this.output.stream();
        }

        private void addNode(Node node) {
            if (node instanceof Text) {
                Text text = (Text)node;
                if (this.buf != null) {
                    this.buf.append(text.text());
                } else if (this.firstText == null) {
                    this.firstText = text.text();
                } else {
                    this.buf = new StringBuilder(this.firstText).append(text.text());
                    this.firstText = null;
                }
            } else {
                this.flushContent();
                this.output.add(node);
            }
        }

        private void flushContent() {
            String text;
            if (this.buf != null) {
                text = this.buf.toString();
                this.buf = null;
            } else if (this.firstText != null) {
                text = this.firstText;
                this.firstText = null;
            } else {
                return;
            }
            CodeBlock codeBlock = CodeBlock.codeBlock((String)text).language(this.language);
            this.output.add((Node)codeBlock);
        }
    }
}

