/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.html.parser;

import com.atlassian.adf.html.parser.ElementParser;
import com.atlassian.adf.html.parser.HtmlParser;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.ListItem;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.BlockquoteContent;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.ListNode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jsoup.nodes.Element;

class BlockParser<C extends ContentNode<C, N>, N extends Node> {
    private final HtmlParser htmlParser;
    private final List<Node> output = new ArrayList<Node>();
    private final Supplier<C> factory;
    private final Class<N> contentClass;
    @Nullable
    private List<Text> texts;
    private C contentNode;

    BlockParser(HtmlParser htmlParser, Supplier<C> factory) {
        this.htmlParser = htmlParser;
        this.factory = factory;
        this.contentNode = (ContentNode)factory.get();
        this.contentClass = this.contentNode.contentClass();
    }

    static <C extends ContentNode<C, N>, N extends Node> ElementParser blockFactory(Supplier<C> factory) {
        return (htmlParser, html) -> BlockParser.parseBlock(htmlParser, html, factory);
    }

    static <C extends ContentNode<C, N>, N extends Node> Stream<? extends Node> parseBlock(HtmlParser htmlParser, Element html, Supplier<C> factory) {
        return new BlockParser<C, N>(htmlParser, factory).parse(html);
    }

    C contentNode() {
        return this.contentNode;
    }

    Stream<? extends Node> parse(Element html) {
        this.htmlParser.parseChildren((org.jsoup.nodes.Node)html).forEach(this::addChildNode);
        this.flushText();
        if (!this.contentNode.isEmpty()) {
            this.output.add((Node)this.contentNode);
        }
        return this.output.stream();
    }

    void addChildNode(Node child) {
        if (child instanceof Text) {
            this.addText((Text)child);
            return;
        }
        if (child instanceof ListItem && !(this.contentNode instanceof ListNode)) {
            ListItem listItem = (ListItem)child;
            listItem.content().forEach(this::addChildNode);
            return;
        }
        this.flushText();
        this.addContentOrOutput(child);
    }

    private void addText(Text text) {
        if (this.texts == null) {
            if (!this.htmlParser.keepWhitespace() && text.text().isBlank()) {
                return;
            }
            if (!this.contentClass.isAssignableFrom(Paragraph.class)) {
                this.flushContentNode();
            }
            this.texts = new ArrayList<Text>();
        }
        this.texts.add(text);
    }

    private void flushText() {
        if (this.texts == null) {
            return;
        }
        List<Text> merged = this.mergeTexts(this.texts);
        this.texts = null;
        if (this.contentClass.isAssignableFrom(Text.class)) {
            this.contentNode.content(merged.stream().map(this.contentClass::cast));
        } else {
            this.addContentOrOutput((Node)Paragraph.p(merged));
        }
    }

    private List<Text> mergeTexts(List<Text> texts) {
        if (texts.size() < 2) {
            return texts;
        }
        ArrayList<Text> result = new ArrayList<Text>(texts.size());
        Text prev = texts.get(0);
        StringBuilder sb = null;
        for (int i = 1; i < texts.size(); ++i) {
            Text curr = texts.get(i);
            if (prev.hasSameMarks(curr)) {
                if (sb == null) {
                    sb = new StringBuilder(prev.text());
                }
                sb.append(curr.text());
                continue;
            }
            if (sb != null) {
                prev.set(sb.toString());
                sb = null;
            }
            result.add(prev);
            prev = curr;
        }
        if (sb != null) {
            prev.set(sb.toString());
        }
        result.add(prev);
        return result;
    }

    void addContentOrOutput(Node child) {
        if (this.isAllowedContent(child)) {
            Node content = (Node)this.contentClass.cast(child);
            this.contentNode.content(content);
        } else {
            this.flushContentNode();
            this.output.add(child);
        }
    }

    boolean isAllowedContent(Node child) {
        if (this.contentClass == BlockquoteContent.class && child instanceof CodeBlock) {
            return false;
        }
        return this.contentClass.isInstance(child);
    }

    private void flushContentNode() {
        if (!this.contentNode.isEmpty()) {
            this.output.add((Node)this.contentNode);
            this.contentNode = (ContentNode)this.factory.get();
        }
    }
}

