package com.atlassian.activeobjects.spi;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.tenancy.api.Tenant;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sql.DataSource;

/**
 * Gives access to the host application data source.
 * Deprecated and replaced by {@link com.atlassian.activeobjects.spi.DataSourceProvider},which provides tenantless methods.
 * Will be removed in the next major 6.0.x AO release
 */
@PublicSpi
@ParametersAreNonnullByDefault
@Deprecated
public interface TenantAwareDataSourceProvider extends DataSourceProvider{

    /**
     * Provide host application data source associated with a tenant.
     *
     * This data source will be used for the entire lifetime of {@code com.atlassian.activeobjects.external.ActiveObjects}
     */
    @Nonnull
    @Deprecated
    DataSource getDataSource(Tenant tenant);

    /**
     * <p>Returns the database type for the tenant</p>
     * <p>Note: if {@link com.atlassian.activeobjects.spi.DatabaseType#UNKNOWN} is return it is left up to the client of
     * the data source provider to 'guess' the type of the database. It is strongly advised to implement this method so
     * that it never returns {@link com.atlassian.activeobjects.spi.DatabaseType#UNKNOWN}.</p>
     *
     * @return a valid database type
     * @see com.atlassian.activeobjects.spi.DatabaseType
     */
    @Nonnull
    @Deprecated
    DatabaseType getDatabaseType(Tenant tenant);

    /**
     * <p>The name of the schema used with this database for the tenant.</p>
     * <p>This is especially import for SQL Server, PostgresQL and HSQLDB</p>
     *
     * @return the name of the schema to use, {@code null} if no schema is required.
     */
    @Nullable
    @Deprecated
    String getSchema(Tenant tenant);

    default String getSchema(){
        return getSchema(null);
    }
    default DatabaseType getDatabaseType(){
        return getDatabaseType(null);
    }
    default DataSource getDataSource(){
        return getDataSource(null);
    }
}
