package com.atlassian.activeobjects.spi;

import com.atlassian.tenancy.api.TenantContext;

import javax.sql.DataSource;

import static java.util.Objects.requireNonNull;

/**
 * Compatibility implementation which calls {@link com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider}
 * with the current tenant.
 * Deprecated has no use since {@link com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider} now extends
 * {@link com.atlassian.activeobjects.spi.DataSourceProvider} and has been replaced by that interface.
 * Must be removed along with {@link com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider} in the next big platform release
 *
 * Will throw {@link java.lang.IllegalStateException} if invoked when there is no tenant present.
 */
@Deprecated
public class DataSourceProviderImpl implements DataSourceProvider {

    private final TenantAwareDataSourceProvider tenantAwareDataSourceProvider;

    //TenantContext param has been left for the needs of compatibility, must be deleted in the next major
    public DataSourceProviderImpl(
            final TenantAwareDataSourceProvider tenantAwareDataSourceProvider, final TenantContext tenantContext) {
        this.tenantAwareDataSourceProvider = requireNonNull(tenantAwareDataSourceProvider);
    }

    @Override
    public DataSource getDataSource() {
        return tenantAwareDataSourceProvider.getDataSource();
    }

    @Override
    public DatabaseType getDatabaseType() {
        return tenantAwareDataSourceProvider.getDatabaseType();
    }

    @Override
    public String getSchema() {
        return tenantAwareDataSourceProvider.getSchema();
    }
}
