package com.atlassian.activeobjects.spi;

import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantAccessor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.stream.StreamSupport;

import static java.util.Objects.requireNonNull;

public class CompatibilityTenantContextImpl implements CompatibilityTenantContext {
    
    private final TenantAccessor tenantAccessor;

    public CompatibilityTenantContextImpl(@Nonnull final TenantAccessor tenantAccessor) {
        this.tenantAccessor = requireNonNull(tenantAccessor);
    }

    /**
     * Retrieves the first of the available tenants (should only be one).
     *
     * @return null if no tenant present (even though the API says not null)
     */
    @Nullable
    @Override
    public Tenant getCurrentTenant() {
        // just get the first (and only) tenant
        return StreamSupport.stream(tenantAccessor.getAvailableTenants().spliterator(), false)
                .findFirst()
                .orElse(null);
    }
}
