/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.spi;

import com.atlassian.activeobjects.spi.ContextClassLoaderThreadFactory;
import com.atlassian.activeobjects.spi.InitExecutorServiceProvider;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.tenancy.api.Tenant;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInitExecutorServiceProvider
implements InitExecutorServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultInitExecutorServiceProvider.class);
    private final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    @VisibleForTesting
    final ThreadFactory aoContextThreadFactory;

    public DefaultInitExecutorServiceProvider(ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.threadLocalDelegateExecutorFactory = threadLocalDelegateExecutorFactory;
        ClassLoader bundleContextClassLoader = Thread.currentThread().getContextClassLoader();
        this.aoContextThreadFactory = new ContextClassLoaderThreadFactory(bundleContextClassLoader);
    }

    @Override
    @Nonnull
    public ExecutorService initExecutorService(@Nonnull Tenant tenant) {
        logger.debug("creating default init executor");
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setThreadFactory(this.aoContextThreadFactory).setNameFormat("active-objects-init-" + tenant.toString() + "-%d").build();
        ExecutorService delegate = Executors.newFixedThreadPool(Integer.getInteger("activeobjects.servicefactory.ddl.threadpoolsize", 1), threadFactory);
        return this.threadLocalDelegateExecutorFactory.createExecutorService(delegate);
    }
}

