/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.spring;

import com.google.common.base.Preconditions;
import org.springframework.beans.factory.FactoryBean;

public final class OptionalServiceFactoryBean<T>
implements FactoryBean {
    private final T service;
    private final T defaultValue;
    private final Class<T> type;

    public OptionalServiceFactoryBean(Class<T> type, T service, T defaultValue) {
        this.type = (Class)Preconditions.checkNotNull(type);
        this.service = Preconditions.checkNotNull(service);
        this.defaultValue = Preconditions.checkNotNull(defaultValue);
    }

    public Object getObject() throws Exception {
        try {
            this.service.toString();
            return this.service;
        }
        catch (RuntimeException e) {
            if (e.getClass().getSimpleName().equals("ServiceUnavailableException")) {
                return this.defaultValue;
            }
            throw e;
        }
    }

    public Class getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }
}

