/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.internal;

import com.atlassian.activeobjects.ActiveObjectsPluginException;
import com.atlassian.activeobjects.config.ActiveObjectsConfiguration;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.activeobjects.internal.AbstractActiveObjectsFactory;
import com.atlassian.activeobjects.internal.ActiveObjectUpgradeManager;
import com.atlassian.activeobjects.internal.ConnectionUnwrapper;
import com.atlassian.activeobjects.internal.DataSourceType;
import com.atlassian.activeobjects.internal.EntityManagedActiveObjects;
import com.atlassian.activeobjects.internal.EntityManagerFactory;
import com.atlassian.activeobjects.internal.SalTransactionManager;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider;
import com.atlassian.activeobjects.spi.TransactionSynchronisationManager;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.tenancy.api.Tenant;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.java.ao.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceProviderActiveObjectsFactory
extends AbstractActiveObjectsFactory {
    private final EntityManagerFactory entityManagerFactory;
    private final TenantAwareDataSourceProvider tenantAwareDataSourceProvider;
    private TransactionSynchronisationManager transactionSynchronizationManager;

    public DataSourceProviderActiveObjectsFactory(ActiveObjectUpgradeManager aoUpgradeManager, EntityManagerFactory entityManagerFactory, TenantAwareDataSourceProvider tenantAwareDataSourceProvider, TransactionTemplate transactionTemplate, ClusterLockService clusterLockService) {
        super(DataSourceType.APPLICATION, aoUpgradeManager, transactionTemplate, clusterLockService);
        this.entityManagerFactory = (EntityManagerFactory)Preconditions.checkNotNull((Object)entityManagerFactory);
        this.tenantAwareDataSourceProvider = (TenantAwareDataSourceProvider)Preconditions.checkNotNull((Object)tenantAwareDataSourceProvider);
    }

    public void setTransactionSynchronizationManager(TransactionSynchronisationManager transactionSynchronizationManager) {
        this.transactionSynchronizationManager = transactionSynchronizationManager;
    }

    @Override
    protected ActiveObjects doCreate(ActiveObjectsConfiguration configuration, Tenant tenant) {
        return (ActiveObjects)this.transactionTemplate.execute(() -> {
            DataSource dataSource = this.getDataSource(tenant);
            DatabaseType dbType = this.getDatabaseType(tenant);
            EntityManager entityManager = this.entityManagerFactory.getEntityManager(dataSource, dbType, this.tenantAwareDataSourceProvider.getSchema(tenant), configuration);
            return new EntityManagedActiveObjects(entityManager, new SalTransactionManager(this.transactionTemplate, entityManager, this.transactionSynchronizationManager), dbType);
        });
    }

    @Override
    protected void upgrade(ActiveObjectsConfiguration configuration, Tenant tenant) {
        DatabaseType dbType = this.getDatabaseType(tenant);
        List<ActiveObjectsUpgradeTask> upgradeTasks = configuration.getUpgradeTasks();
        if (dbType == DatabaseType.POSTGRESQL || dbType == DatabaseType.UNKNOWN) {
            DataSource dataSource = this.getDataSource(tenant);
            upgradeTasks = upgradeTasks.stream().map(task -> new PostgresActiveObjectsUpgradeTask(dataSource, (ActiveObjectsUpgradeTask)task)).collect(Collectors.toList());
        }
        this.aoUpgradeManager.upgrade(configuration.getTableNamePrefix(), upgradeTasks, (Supplier<ActiveObjects>)((Supplier)() -> this.doCreate(configuration, tenant)));
    }

    private DataSource getDataSource(Tenant tenant) {
        DataSource dataSource = this.tenantAwareDataSourceProvider.getDataSource(tenant);
        if (dataSource == null) {
            throw new ActiveObjectsPluginException("No data source defined in the application");
        }
        return new ActiveObjectsDataSource(dataSource);
    }

    private DatabaseType getDatabaseType(Tenant tenant) {
        DatabaseType databaseType = this.tenantAwareDataSourceProvider.getDatabaseType(tenant);
        if (databaseType == null) {
            throw new ActiveObjectsPluginException("No database type defined in the application");
        }
        return databaseType;
    }

    private static class PostgresActiveObjectsUpgradeTask
    implements ActiveObjectsUpgradeTask {
        private static final Logger logger = LoggerFactory.getLogger(PostgresActiveObjectsUpgradeTask.class);
        private final DataSource dataSource;
        private final ActiveObjectsUpgradeTask delegate;

        private PostgresActiveObjectsUpgradeTask(DataSource dataSource, ActiveObjectsUpgradeTask delegate) {
            this.dataSource = dataSource;
            this.delegate = delegate;
        }

        @Override
        public ModelVersion getModelVersion() {
            return this.delegate.getModelVersion();
        }

        @Override
        public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
            boolean upgraded = this.configureConnectionAndRun(currentVersion, ao);
            if (!upgraded) {
                this.delegate.upgrade(currentVersion, ao);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean configureConnectionAndRun(ModelVersion currentVersion, ActiveObjects ao) {
            try (Connection c = this.dataSource.getConnection();){
                Method setPrepareThreshold;
                int previousPrepareThreshold;
                Connection connection = ConnectionUnwrapper.tryUnwrapConnection(c).orElse(c);
                try {
                    Method getPrepareThreshold = connection.getClass().getMethod("getPrepareThreshold", new Class[0]);
                    previousPrepareThreshold = (Integer)getPrepareThreshold.invoke((Object)connection, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.warn("Failed to retrieve prepare threshold", (Throwable)e);
                    boolean bl = false;
                    if (c == null) return bl;
                    if (var4_5 == null) {
                        c.close();
                        return bl;
                    }
                    try {
                        c.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                        return bl;
                    }
                }
                if (previousPrepareThreshold == 0) {
                    boolean e = false;
                    return e;
                }
                try {
                    setPrepareThreshold = connection.getClass().getMethod("setPrepareThreshold", Integer.TYPE);
                    setPrepareThreshold.invoke((Object)connection, 0);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.warn("Failed to disable server side prepared statements", (Throwable)e);
                    boolean bl = false;
                    if (c == null) return bl;
                    if (var4_5 == null) {
                        c.close();
                        return bl;
                    }
                    try {
                        c.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                        return bl;
                    }
                }
                try {
                    this.delegate.upgrade(currentVersion, ao);
                }
                catch (Throwable throwable) {
                    try {
                        setPrepareThreshold.invoke((Object)connection, previousPrepareThreshold);
                        throw throwable;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        logger.warn("Failed to reset server side prepared statements", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    setPrepareThreshold.invoke((Object)connection, previousPrepareThreshold);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    logger.warn("Failed to reset server side prepared statements", (Throwable)e);
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                logger.warn("Failed to retrieve connection", (Throwable)e);
                return false;
            }
        }
    }

    public static class ActiveObjectsDataSource
    implements DataSource {
        private final DataSource dataSource;

        ActiveObjectsDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }

        @Override
        public Connection getConnection(String username, String password) {
            throw new IllegalStateException("Not allowed to get a connection for non default username/password");
        }

        @Override
        public int getLoginTimeout() {
            return 0;
        }

        @Override
        public void setLoginTimeout(int timeout) {
            throw new UnsupportedOperationException("setLoginTimeout");
        }

        @Override
        public PrintWriter getLogWriter() {
            throw new UnsupportedOperationException("getLogWriter");
        }

        @Override
        public void setLogWriter(PrintWriter pw) {
            throw new UnsupportedOperationException("setLogWriter");
        }

        @Override
        public <T> T unwrap(Class<T> tClass) {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public boolean isWrapperFor(Class<?> aClass) {
            throw new UnsupportedOperationException("isWrapperFor");
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }
    }
}

