/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.osgi;

import com.atlassian.activeobjects.config.ActiveObjectsConfiguration;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsModuleMetaData;
import com.atlassian.activeobjects.external.NoDataSourceException;
import com.atlassian.activeobjects.internal.ActiveObjectsFactory;
import com.atlassian.activeobjects.internal.ActiveObjectsInitException;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TenantAwareActiveObjects
implements ActiveObjects {
    private static final Logger logger = LoggerFactory.getLogger(TenantAwareActiveObjects.class);
    private final Bundle bundle;
    private final ExecutorService executorService;
    private final TenantContext tenantContext;
    @VisibleForTesting
    final SettableFuture<ActiveObjectsConfiguration> aoConfigFuture = SettableFuture.create();
    @VisibleForTesting
    final LoadingCache<Tenant, Promise<ActiveObjects>> aoPromisesByTenant;

    TenantAwareActiveObjects(final @Nonnull Bundle bundle, final @Nonnull ActiveObjectsFactory factory, @Nonnull TenantContext tenantContext, final @Nonnull Function<Tenant, ExecutorService> initExecutorFunction) {
        this.bundle = (Bundle)Preconditions.checkNotNull((Object)bundle);
        this.tenantContext = (TenantContext)Preconditions.checkNotNull((Object)tenantContext);
        Preconditions.checkNotNull((Object)factory);
        Preconditions.checkNotNull(initExecutorFunction);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TenantAwareActiveObjects-thread-%d").build();
        this.executorService = Executors.newCachedThreadPool(threadFactory);
        this.aoPromisesByTenant = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Tenant, Promise<ActiveObjects>>(){

            public Promise<ActiveObjects> load(final @Nonnull Tenant tenant) {
                logger.debug("bundle [{}] loading new AO promise for {}", (Object)bundle.getSymbolicName(), (Object)tenant);
                return Promises.forFuture(TenantAwareActiveObjects.this.aoConfigFuture, (Executor)TenantAwareActiveObjects.this.executorService).flatMap((Function)new Function<ActiveObjectsConfiguration, Promise<ActiveObjects>>(){

                    @Override
                    public Promise<ActiveObjects> apply(final @Nullable ActiveObjectsConfiguration aoConfig) {
                        logger.debug("bundle [{}] got ActiveObjectsConfiguration", (Object)bundle.getSymbolicName(), (Object)tenant);
                        final SettableFuture aoFuture = SettableFuture.create();
                        ((ExecutorService)initExecutorFunction.apply(tenant)).submit(new Callable<Void>(){

                            @Override
                            public Void call() {
                                try {
                                    logger.debug("bundle [{}] creating ActiveObjects", (Object)bundle.getSymbolicName());
                                    ActiveObjects ao = factory.create(aoConfig, tenant);
                                    logger.debug("bundle [{}] created ActiveObjects", (Object)bundle.getSymbolicName());
                                    aoFuture.set((Object)ao);
                                }
                                catch (Throwable t) {
                                    ActiveObjectsInitException activeObjectsInitException = new ActiveObjectsInitException("bundle [" + bundle.getSymbolicName() + "]", t);
                                    aoFuture.setException((Throwable)activeObjectsInitException);
                                    logger.warn("bundle [{}] failed to create ActiveObjects", (Object)bundle.getSymbolicName(), (Object)t);
                                }
                                return null;
                            }
                        });
                        return Promises.forFuture((Future)aoFuture, (Executor)TenantAwareActiveObjects.this.executorService);
                    }
                });
            }
        });
    }

    public void init() {
        logger.debug("init bundle [{}]", (Object)this.bundle.getSymbolicName());
        Tenant tenant = this.tenantContext.getCurrentTenant();
        if (tenant != null) {
            this.aoPromisesByTenant.invalidate((Object)tenant);
            this.startActiveObjects(tenant);
        }
    }

    public void destroy() {
        this.aoConfigFuture.cancel(false);
        for (Promise aoPromise : this.aoPromisesByTenant.asMap().values()) {
            aoPromise.cancel(false);
        }
        this.executorService.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setAoConfiguration(@Nonnull ActiveObjectsConfiguration aoConfiguration) {
        ActiveObjectsConfiguration currentAoConfiguration;
        logger.debug("setAoConfiguration [{}]", (Object)this.bundle.getSymbolicName());
        if (!this.aoConfigFuture.isDone()) {
            this.aoConfigFuture.set((Object)aoConfiguration);
            return;
        }
        try {
            currentAoConfiguration = (ActiveObjectsConfiguration)this.aoConfigFuture.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
        if (currentAoConfiguration == aoConfiguration) {
            logger.debug("setAoConfiguration received same <ao> configuration twice [{}]", (Object)aoConfiguration);
            return;
        }
        IllegalStateException e = new IllegalStateException("bundle [" + this.bundle.getSymbolicName() + "] has multiple active objects configurations - only one active objects module descriptor <ao> allowed per plugin!");
        this.aoConfigFuture.setException((Throwable)e);
        throw e;
    }

    void startActiveObjects(@Nonnull Tenant tenant) {
        Preconditions.checkNotNull((Object)tenant);
        this.aoPromisesByTenant.getUnchecked((Object)tenant);
    }

    void restartActiveObjects(@Nonnull Tenant tenant) {
        Preconditions.checkNotNull((Object)tenant);
        this.aoPromisesByTenant.invalidate((Object)tenant);
        this.aoPromisesByTenant.getUnchecked((Object)tenant);
    }

    @VisibleForTesting
    protected Promise<ActiveObjects> delegate() {
        if (!this.aoConfigFuture.isDone()) {
            throw new IllegalStateException("plugin [{" + this.bundle.getSymbolicName() + "}] invoking ActiveObjects before <ao> configuration module is enabled or plugin is missing an <ao> configuration module. Note that scanning of entities from the ao.model package is no longer supported.");
        }
        Tenant tenant = this.tenantContext.getCurrentTenant();
        if (tenant != null) {
            return (Promise)this.aoPromisesByTenant.getUnchecked((Object)tenant);
        }
        throw new NoDataSourceException();
    }

    @Override
    public ActiveObjectsModuleMetaData moduleMetaData() {
        return new ActiveObjectsModuleMetaData(){

            @Override
            public void awaitInitialization() throws ExecutionException, InterruptedException {
                Tenant tenant = TenantAwareActiveObjects.this.tenantContext.getCurrentTenant();
                if (tenant == null) {
                    throw new NoDataSourceException();
                }
                ((Promise)TenantAwareActiveObjects.this.aoPromisesByTenant.getUnchecked((Object)tenant)).get();
            }

            @Override
            public void awaitInitialization(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                Tenant tenant = TenantAwareActiveObjects.this.tenantContext.getCurrentTenant();
                if (tenant == null) {
                    throw new NoDataSourceException();
                }
                ((Promise)TenantAwareActiveObjects.this.aoPromisesByTenant.getUnchecked((Object)tenant)).get(timeout, unit);
            }

            @Override
            public boolean isInitialized() {
                Promise aoPromise;
                Tenant tenant = TenantAwareActiveObjects.this.tenantContext.getCurrentTenant();
                if (tenant != null && (aoPromise = (Promise)TenantAwareActiveObjects.this.aoPromisesByTenant.getUnchecked((Object)tenant)).isDone()) {
                    try {
                        aoPromise.claim();
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }

            @Override
            public DatabaseType getDatabaseType() {
                return ((ActiveObjects)TenantAwareActiveObjects.this.delegate().claim()).moduleMetaData().getDatabaseType();
            }

            @Override
            public boolean isDataSourcePresent() {
                return TenantAwareActiveObjects.this.tenantContext.getCurrentTenant() != null;
            }

            @Override
            public boolean isTablePresent(Class<? extends RawEntity<?>> type) {
                return ((ActiveObjects)TenantAwareActiveObjects.this.delegate().claim()).moduleMetaData().isTablePresent(type);
            }
        };
    }

    @Override
    public void migrate(Class<? extends RawEntity<?>> ... entities) {
        ((ActiveObjects)this.delegate().claim()).migrate(entities);
    }

    @Override
    public void migrateDestructively(Class<? extends RawEntity<?>> ... entities) {
        ((ActiveObjects)this.delegate().claim()).migrateDestructively(entities);
    }

    @Override
    public void flushAll() {
        ((ActiveObjects)this.delegate().claim()).flushAll();
    }

    @Override
    public void flush(RawEntity<?> ... entities) {
        ((ActiveObjects)this.delegate().claim()).flush(entities);
    }

    @Override
    public <T extends RawEntity<K>, K> T[] get(Class<T> type, K ... keys) {
        return ((ActiveObjects)this.delegate().claim()).get(type, keys);
    }

    @Override
    public <T extends RawEntity<K>, K> T get(Class<T> type, K key) {
        return ((ActiveObjects)this.delegate().claim()).get(type, key);
    }

    @Override
    public <T extends RawEntity<K>, K> T create(Class<T> type, DBParam ... params) {
        return ((ActiveObjects)this.delegate().claim()).create(type, params);
    }

    @Override
    public <T extends RawEntity<K>, K> T create(Class<T> type, Map<String, Object> params) {
        return ((ActiveObjects)this.delegate().claim()).create(type, params);
    }

    @Override
    public void delete(RawEntity<?> ... entities) {
        ((ActiveObjects)this.delegate().claim()).delete(entities);
    }

    @Override
    public <K> int deleteWithSQL(Class<? extends RawEntity<K>> type, String criteria, Object ... parameters) {
        return ((ActiveObjects)this.delegate().claim()).deleteWithSQL(type, criteria, parameters);
    }

    @Override
    public <T extends RawEntity<K>, K> T[] find(Class<T> type) {
        return ((ActiveObjects)this.delegate().claim()).find(type);
    }

    @Override
    public <T extends RawEntity<K>, K> T[] find(Class<T> type, String criteria, Object ... parameters) {
        return ((ActiveObjects)this.delegate().claim()).find(type, criteria, parameters);
    }

    @Override
    public <T extends RawEntity<K>, K> T[] find(Class<T> type, Query query) {
        return ((ActiveObjects)this.delegate().claim()).find(type, query);
    }

    @Override
    public <T extends RawEntity<K>, K> T[] find(Class<T> type, String field, Query query) {
        return ((ActiveObjects)this.delegate().claim()).find(type, field, query);
    }

    @Override
    public <T extends RawEntity<K>, K> T[] findWithSQL(Class<T> type, String keyField, String sql, Object ... parameters) {
        return ((ActiveObjects)this.delegate().claim()).findWithSQL(type, keyField, sql, parameters);
    }

    @Override
    public <T extends RawEntity<K>, K> void stream(Class<T> type, EntityStreamCallback<T, K> streamCallback) {
        ((ActiveObjects)this.delegate().claim()).stream(type, streamCallback);
    }

    @Override
    public <T extends RawEntity<K>, K> void stream(Class<T> type, Query query, EntityStreamCallback<T, K> streamCallback) {
        ((ActiveObjects)this.delegate().claim()).stream(type, query, streamCallback);
    }

    @Override
    public <K> int count(Class<? extends RawEntity<K>> type) {
        return ((ActiveObjects)this.delegate().claim()).count(type);
    }

    @Override
    public <K> int count(Class<? extends RawEntity<K>> type, String criteria, Object ... parameters) {
        return ((ActiveObjects)this.delegate().claim()).count(type, criteria, parameters);
    }

    @Override
    public <K> int count(Class<? extends RawEntity<K>> type, Query query) {
        return ((ActiveObjects)this.delegate().claim()).count(type, query);
    }

    @Override
    public <T> T executeInTransaction(TransactionCallback<T> callback) {
        return ((ActiveObjects)this.delegate().claim()).executeInTransaction(callback);
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

