/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.internal;

import com.atlassian.activeobjects.ActiveObjectsPluginException;
import com.atlassian.activeobjects.config.ActiveObjectsConfiguration;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.internal.AbstractActiveObjectsFactory;
import com.atlassian.activeobjects.internal.ActiveObjectUpgradeManager;
import com.atlassian.activeobjects.internal.DataSourceType;
import com.atlassian.activeobjects.internal.EntityManagedActiveObjects;
import com.atlassian.activeobjects.internal.EntityManagerFactory;
import com.atlassian.activeobjects.internal.SalTransactionManager;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider;
import com.atlassian.activeobjects.spi.TransactionSynchronisationManager;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.tenancy.api.Tenant;
import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.java.ao.EntityManager;

public final class DataSourceProviderActiveObjectsFactory
extends AbstractActiveObjectsFactory {
    private final EntityManagerFactory entityManagerFactory;
    private final TenantAwareDataSourceProvider tenantAwareDataSourceProvider;
    private TransactionSynchronisationManager transactionSynchronizationManager;

    public DataSourceProviderActiveObjectsFactory(ActiveObjectUpgradeManager aoUpgradeManager, EntityManagerFactory entityManagerFactory, TenantAwareDataSourceProvider tenantAwareDataSourceProvider, TransactionTemplate transactionTemplate, ClusterLockService clusterLockService) {
        super(DataSourceType.APPLICATION, aoUpgradeManager, transactionTemplate, clusterLockService);
        this.entityManagerFactory = (EntityManagerFactory)Preconditions.checkNotNull((Object)entityManagerFactory);
        this.tenantAwareDataSourceProvider = (TenantAwareDataSourceProvider)Preconditions.checkNotNull((Object)tenantAwareDataSourceProvider);
    }

    public void setTransactionSynchronizationManager(TransactionSynchronisationManager transactionSynchronizationManager) {
        this.transactionSynchronizationManager = transactionSynchronizationManager;
    }

    @Override
    protected ActiveObjects doCreate(final ActiveObjectsConfiguration configuration, final Tenant tenant) {
        return (ActiveObjects)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<ActiveObjects>(){

            public ActiveObjects doInTransaction() {
                DataSource dataSource = DataSourceProviderActiveObjectsFactory.this.getDataSource(tenant);
                DatabaseType dbType = DataSourceProviderActiveObjectsFactory.this.getDatabaseType(tenant);
                EntityManager entityManager = DataSourceProviderActiveObjectsFactory.this.entityManagerFactory.getEntityManager(dataSource, dbType, DataSourceProviderActiveObjectsFactory.this.tenantAwareDataSourceProvider.getSchema(tenant), configuration);
                return new EntityManagedActiveObjects(entityManager, new SalTransactionManager(DataSourceProviderActiveObjectsFactory.this.transactionTemplate, entityManager, DataSourceProviderActiveObjectsFactory.this.transactionSynchronizationManager), dbType);
            }
        });
    }

    private DataSource getDataSource(Tenant tenant) {
        DataSource dataSource = this.tenantAwareDataSourceProvider.getDataSource(tenant);
        if (dataSource == null) {
            throw new ActiveObjectsPluginException("No data source defined in the application");
        }
        return new ActiveObjectsDataSource(dataSource);
    }

    private DatabaseType getDatabaseType(Tenant tenant) {
        DatabaseType databaseType = this.tenantAwareDataSourceProvider.getDatabaseType(tenant);
        if (databaseType == null) {
            throw new ActiveObjectsPluginException("No database type defined in the application");
        }
        return databaseType;
    }

    public static class ActiveObjectsDataSource
    implements DataSource {
        private final DataSource dataSource;

        ActiveObjectsDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new IllegalStateException("Not allowed to get a connection for non default username/password");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public void setLoginTimeout(int timeout) throws SQLException {
            throw new UnsupportedOperationException("setLoginTimeout");
        }

        @Override
        public PrintWriter getLogWriter() {
            throw new UnsupportedOperationException("getLogWriter");
        }

        @Override
        public void setLogWriter(PrintWriter pw) throws SQLException {
            throw new UnsupportedOperationException("setLogWriter");
        }

        @Override
        public <T> T unwrap(Class<T> tClass) throws SQLException {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public boolean isWrapperFor(Class<?> aClass) throws SQLException {
            throw new UnsupportedOperationException("isWrapperFor");
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }
    }
}

