/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.dbexporter.exporter;

import com.atlassian.dbexporter.Context;
import com.atlassian.dbexporter.EntityNameProcessor;
import com.atlassian.dbexporter.ImportExportErrorService;
import com.atlassian.dbexporter.exporter.ExportConfiguration;
import com.atlassian.dbexporter.exporter.Exporter;
import com.atlassian.dbexporter.exporter.TableSelector;
import com.atlassian.dbexporter.jdbc.JdbcUtils;
import com.atlassian.dbexporter.node.NodeBackup;
import com.atlassian.dbexporter.node.NodeCreator;
import com.atlassian.dbexporter.progress.ProgressMonitor;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;

public final class DataExporter
implements Exporter {
    private final ImportExportErrorService errorService;
    private final String schema;
    private final TableSelector tableSelector;

    public DataExporter(ImportExportErrorService errorService, String schema, TableSelector tableSelector) {
        this.errorService = (ImportExportErrorService)Preconditions.checkNotNull((Object)errorService);
        this.schema = DataExporter.isBlank(schema) ? null : schema;
        this.tableSelector = (TableSelector)Preconditions.checkNotNull((Object)tableSelector);
    }

    @Override
    public void export(final NodeCreator node, final ExportConfiguration configuration, Context context) {
        final ProgressMonitor monitor = configuration.getProgressMonitor();
        monitor.begin(ProgressMonitor.Task.TABLES_DATA, new Object[0]);
        JdbcUtils.withConnection(this.errorService, configuration.getConnectionProvider(), new JdbcUtils.JdbcCallable<Void>(){

            @Override
            public Void call(Connection connection) {
                for (String table : DataExporter.this.getTableNames(connection)) {
                    DataExporter.this.exportTable(table, connection, node, monitor, configuration.getEntityNameProcessor());
                }
                node.closeEntity();
                return null;
            }
        });
        monitor.end(ProgressMonitor.Task.TABLES_DATA, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getTableNames(Connection connection) {
        HashSet<String> tables = new HashSet<String>();
        ResultSet result = this.getTablesResultSet(connection);
        try {
            String tableName;
            do {
                if (!this.tableSelector.accept(tableName = this.tableName(result))) continue;
                tables.add(tableName);
            } while (tableName != null);
            HashSet<String> hashSet = tables;
            return hashSet;
        }
        finally {
            JdbcUtils.closeQuietly(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeCreator exportTable(String table, Connection connection, NodeCreator node, ProgressMonitor monitor, EntityNameProcessor entityNameProcessor) {
        monitor.begin(ProgressMonitor.Task.TABLE_DATA, entityNameProcessor.tableName(table));
        NodeBackup.TableDataNode.add(node, entityNameProcessor.tableName(table));
        Statement statement = JdbcUtils.createStatement(this.errorService, table, connection);
        ResultSet result = null;
        try {
            result = this.executeQueryWithFetchSize(table, statement, "SELECT * FROM " + this.tableName(table, connection), 100);
            ResultSetMetaData meta = this.resultSetMetaData(table, result);
            node = this.writeColumnDefinitions(table, node, meta, entityNameProcessor);
            while (this.next(table, result)) {
                node = this.exportRow(table, node, result, monitor);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(result, statement);
            throw throwable;
        }
        JdbcUtils.closeQuietly(result, statement);
        monitor.end(ProgressMonitor.Task.TABLE_DATA, entityNameProcessor.tableName(table));
        return node.closeEntity();
    }

    private String tableName(String table, Connection connection) {
        String quoted = JdbcUtils.quote(this.errorService, table, connection, table);
        return this.schema != null ? this.schema + "." + quoted : quoted;
    }

    private NodeCreator exportRow(String table, NodeCreator node, ResultSet result, ProgressMonitor monitor) {
        monitor.begin(ProgressMonitor.Task.TABLE_ROW, new Object[0]);
        ResultSetMetaData metaData = this.resultSetMetaData(table, result);
        NodeBackup.RowDataNode.add(node);
        block9: for (int col = 1; col <= this.columnCount(table, metaData); ++col) {
            switch (this.columnType(table, metaData, col)) {
                case -5: 
                case 4: {
                    this.appendInteger(table, result, col, node);
                    continue block9;
                }
                case 2: {
                    if (this.scale(table, metaData, col) > 0 || this.precision(table, metaData, col) == 126) {
                        this.appendDouble(table, result, col, node);
                        continue block9;
                    }
                    this.appendInteger(table, result, col, node);
                    continue block9;
                }
                case -1: 
                case 12: {
                    String s = this.getString(table, result, col);
                    NodeBackup.RowDataNode.append(node, this.wasNull(table, result) ? null : s);
                    continue block9;
                }
                case -7: 
                case 16: {
                    boolean b = this.getBoolean(table, result, col);
                    NodeBackup.RowDataNode.append(node, this.wasNull(table, result) ? null : Boolean.valueOf(b));
                    continue block9;
                }
                case 3: 
                case 8: {
                    this.appendDouble(table, result, col, node);
                    continue block9;
                }
                case 93: {
                    Timestamp t = this.getTimestamp(table, result, col);
                    NodeBackup.RowDataNode.append(node, this.wasNull(table, result) ? null : t);
                    continue block9;
                }
                case 2005: {
                    String c = this.getClobAsString(table, result, col);
                    NodeBackup.RowDataNode.append(node, this.wasNull(table, result) ? null : c);
                    continue block9;
                }
                default: {
                    throw this.errorService.newImportExportException(table, String.format("Cannot encode value for unsupported column type: \"%s\" (%d) of column %s.%s", this.columnTypeName(table, metaData, col), this.columnType(table, metaData, col), table, this.columnName(table, metaData, col)));
                }
            }
        }
        monitor.end(ProgressMonitor.Task.TABLE_ROW, new Object[0]);
        return node.closeEntity();
    }

    private void appendInteger(String table, ResultSet result, int col, NodeCreator node) {
        BigDecimal bd = this.getBigDecimal(table, result, col);
        NodeBackup.RowDataNode.append(node, this.wasNull(table, result) ? null : bd.toBigInteger());
    }

    private void appendDouble(String table, ResultSet result, int col, NodeCreator node) {
        double d = this.getDouble(table, result, col);
        NodeBackup.RowDataNode.append(node, this.wasNull(table, result) ? null : BigDecimal.valueOf(d));
    }

    private NodeCreator writeColumnDefinitions(String table, NodeCreator node, ResultSetMetaData metaData, EntityNameProcessor entityNameProcessor) {
        for (int i = 1; i <= this.columnCount(table, metaData); ++i) {
            String columnName = entityNameProcessor.columnName(this.columnName(table, metaData, i));
            NodeBackup.ColumnDataNode.add(node, columnName).closeEntity();
        }
        return node;
    }

    private ResultSetMetaData resultSetMetaData(String table, ResultSet result) {
        try {
            return result.getMetaData();
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get result set metadata", e);
        }
    }

    private String tableName(ResultSet rs) {
        try {
            return this.next(null, rs) ? rs.getString("TABLE_NAME") : null;
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(null, "Could not get table name from result set", e);
        }
    }

    private int scale(String table, ResultSetMetaData metaData, int col) {
        try {
            return metaData.getScale(col);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get scale for col #" + col + " from result set meta data", e);
        }
    }

    private int precision(String table, ResultSetMetaData metaData, int col) {
        try {
            return metaData.getPrecision(col);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get scale for col #" + col + " from result set meta data", e);
        }
    }

    private int columnCount(String table, ResultSetMetaData metaData) {
        try {
            return metaData.getColumnCount();
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get column count from result set metadata", e);
        }
    }

    private int columnType(String table, ResultSetMetaData metaData, int col) {
        try {
            return metaData.getColumnType(col);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get column type for col #" + col + " from result set meta data", e);
        }
    }

    private String columnTypeName(String table, ResultSetMetaData metaData, int col) {
        try {
            return metaData.getColumnTypeName(col);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get column type name for col #" + col + " from result set meta data", e);
        }
    }

    private String columnName(String table, ResultSetMetaData metaData, int i) {
        try {
            return metaData.getColumnName(i);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get column #" + i + " name from result set meta data", e);
        }
    }

    private String getString(String table, ResultSet result, int col) {
        try {
            return result.getString(col);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get string value for col #" + col, e);
        }
    }

    private boolean getBoolean(String table, ResultSet result, int col) {
        try {
            return result.getBoolean(col);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get boolean value for col #" + col, e);
        }
    }

    private BigDecimal getBigDecimal(String table, ResultSet result, int col) {
        try {
            return result.getBigDecimal(col);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get big decimal value for col #" + col, e);
        }
    }

    private double getDouble(String table, ResultSet result, int col) {
        try {
            return result.getDouble(col);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get double value for col #" + col, e);
        }
    }

    private Timestamp getTimestamp(String table, ResultSet result, int col) {
        try {
            return result.getTimestamp(col);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get timestamp value for col #" + col, e);
        }
    }

    private String getClobAsString(String table, ResultSet result, int col) {
        try {
            Clob clob = result.getClob(col);
            return clob == null ? null : clob.getSubString(1L, (int)clob.length());
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get clob value for col #" + col, e);
        }
    }

    private boolean wasNull(String table, ResultSet result) {
        try {
            return result.wasNull();
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not figure out whether value was NULL", e);
        }
    }

    private boolean next(String table, ResultSet result) {
        try {
            return result.next();
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not get next for result set", e);
        }
    }

    private ResultSet getTablesResultSet(Connection connection) {
        try {
            return JdbcUtils.metadata(this.errorService, connection).getTables(null, this.schema, "%", new String[]{"TABLE"});
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(null, "Could not read tables in data exporter", e);
        }
    }

    private ResultSet executeQueryWithFetchSize(String table, Statement statement, String sql, int fetchSize) {
        try {
            statement.setFetchSize(fetchSize);
            return statement.executeQuery(sql);
        }
        catch (SQLException e) {
            throw this.errorService.newImportExportSqlException(table, "Could not execute query '" + sql + "' with fetch size " + fetchSize, e);
        }
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

