/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss.loader;

import com.asual.lesscss.loader.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StreamResourceLoader
implements ResourceLoader {
    private static final Pattern PATTERN = Pattern.compile("^([\\w]{2,}):(.*)");

    protected abstract String getSchema();

    protected abstract InputStream openStream(String var1) throws IOException;

    @Override
    public boolean exists(String resource, String[] paths) throws IOException {
        String pathToResource = this.getSchemalessPath(resource, true, false);
        if (pathToResource != null && this.exists(pathToResource)) {
            return true;
        }
        if (!this.getSchemaMatcher(resource).matches()) {
            for (String path : paths) {
                pathToResource = this.getSchemalessPath(this.appendPathToResource(path, resource), false, false);
                if (pathToResource == null || !this.exists(pathToResource)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String load(String resource, String[] paths, String charset) throws IOException {
        String content = this.load(this.getSchemalessPath(resource, true, true), charset);
        if (content != null) {
            return content;
        }
        if (!this.getSchemaMatcher(resource).matches()) {
            for (String path : paths) {
                content = this.load(this.getSchemalessPath(this.appendPathToResource(path, resource), false, true), charset);
                if (content == null) continue;
                return content;
            }
        }
        throw new IOException("No such file " + resource);
    }

    private String load(String resourcePath, String charset) throws IOException {
        InputStream is;
        if (resourcePath != null && (is = this.openStream(resourcePath)) != null) {
            String readStream = this.readStream(is, charset);
            return readStream;
        }
        return null;
    }

    private String getSchemalessPath(String resourcePath, boolean matchOnSchemaOnly, boolean failOnInvalidSchema) throws IOException {
        Matcher m = this.getSchemaMatcher(resourcePath);
        if (m.matches()) {
            if (m.group(1).equals(this.getSchema())) {
                return m.group(2);
            }
            if (failOnInvalidSchema) {
                throw new IOException("Invalid stream type for provided path " + resourcePath);
            }
            return null;
        }
        if (matchOnSchemaOnly) {
            return null;
        }
        return resourcePath;
    }

    private Matcher getSchemaMatcher(String resourcePath) {
        return PATTERN.matcher(resourcePath);
    }

    private boolean exists(String resourcePath) throws IOException {
        InputStream stream = this.openStream(resourcePath);
        if (stream != null) {
            stream.close();
            return true;
        }
        return false;
    }

    private String appendPathToResource(String path, String resource) {
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            return path + "/" + resource;
        }
        return path + resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readStream(InputStream is, String charset) throws IOException {
        InputStreamReader r = new InputStreamReader(is, charset);
        StringWriter w = new StringWriter();
        try {
            char[] b = new char[4096];
            int c = 0;
            while (c >= 0) {
                c = r.read(b);
                if (c <= 0) continue;
                w.write(b, 0, c);
            }
            String string = w.toString();
            return string;
        }
        finally {
            w.close();
            ((Reader)r).close();
        }
    }
}

