/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.ocr.sample.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;

public class RoundedBorder
implements Border {
    protected int cornerRadius;
    protected Color color;

    public RoundedBorder() {
        this(10, Color.lightGray);
    }

    public RoundedBorder(int cornerRadius, Color color) {
        this.cornerRadius = cornerRadius;
        this.setColor(color);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = insets.bottom = this.cornerRadius / 2;
        insets.right = 1;
        insets.left = 1;
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.color == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(RoundedBorder.deriveColorAlpha(this.color, 40));
        g2.drawRoundRect(x, y + 2, width - 1, height - 3, this.cornerRadius, this.cornerRadius);
        g2.setColor(RoundedBorder.deriveColorAlpha(this.color, 90));
        g2.drawRoundRect(x, y + 1, width - 1, height - 2, this.cornerRadius, this.cornerRadius);
        g2.setColor(RoundedBorder.deriveColorAlpha(this.color, 255));
        g2.drawRoundRect(x, y, width - 1, height - 1, this.cornerRadius, this.cornerRadius);
        g2.dispose();
    }

    public static BufferedImage createTranslucentImage(int width, int height) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height, 3);
    }

    public static Color deriveColorAlpha(Color base, int alpha) {
        return new Color(base.getRed(), base.getGreen(), base.getBlue(), alpha);
    }

    public static Color deriveColorHSB(Color base, float dH, float dS, float dB) {
        float[] hsb = Color.RGBtoHSB(base.getRed(), base.getGreen(), base.getBlue(), null);
        hsb[0] = hsb[0] + dH;
        hsb[1] = hsb[1] + dS;
        hsb[2] = hsb[2] + dB;
        return Color.getHSBColor(hsb[0] < 0.0f ? 0.0f : (hsb[0] > 1.0f ? 1.0f : hsb[0]), hsb[1] < 0.0f ? 0.0f : (hsb[1] > 1.0f ? 1.0f : hsb[1]), hsb[2] < 0.0f ? 0.0f : (hsb[2] > 1.0f ? 1.0f : hsb[2]));
    }
}

