/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.ocr.sample;

import com.asprise.ocr.sample.DemoUtils;
import com.asprise.ocr.sample.util.ActionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.GregorianCalendar;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class PanelLogging
extends JPanel {
    ActionBase actionCopyLogs = new ActionBase("Copy"){

        public void actionPerformed(ActionEvent e) {
            PanelLogging.setClipboard(PanelLogging.this.textLogging.getText());
            JOptionPane.showMessageDialog(PanelLogging.getContainingWindow(PanelLogging.this), "Logs have been copied to system clipboard successfully.");
        }
    };
    ActionBase actionClearLogs = new ActionBase("Clear"){

        public void actionPerformed(ActionEvent e) {
            PanelLogging.this.textLogging.setText("");
        }
    };
    private JScrollPane jScrollPane1;
    private JTextArea textLogging;

    public PanelLogging() {
        this.initComponents();
        this.init();
    }

    void init() {
        DemoUtils.enableMenu(this.textLogging);
    }

    public void log(String mesg) {
        PanelLogging.logAndScrollToBottom(this.textLogging, this.formatMessage(mesg));
    }

    private static void logAndScrollToBottom(final JTextArea textArea, final String mesg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PanelLogging.logAndScrollToBottom(textArea, mesg);
                }
            });
            return;
        }
        textArea.append(textArea.getText().length() == 0 ? mesg : "\n" + mesg);
        textArea.setCaretPosition(textArea.getText().length() - 1);
    }

    String formatMessage(String mesg) {
        String threadName = Thread.currentThread().getName();
        if (threadName.length() > 10) {
            threadName = threadName.substring(threadName.length() - 10, threadName.length());
        }
        return String.format("%1$tH:%1$tM:%1$tS.%1$tL %2$-10s %3$s", new GregorianCalendar(), threadName, mesg);
    }

    public static void setClipboard(String content) {
        StringSelection ss = new StringSelection(content);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public static Window getContainingWindow(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textLogging = new JTextArea();
        this.textLogging.setEditable(false);
        this.textLogging.setBackground(new Color(214, 240, 240));
        this.textLogging.setColumns(20);
        this.textLogging.setFont(new Font("Monospaced", 0, 12));
        this.textLogging.setRows(5);
        this.jScrollPane1.setViewportView(this.textLogging);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 209, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
    }
}

