/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import java.util.HashSet;
import java.util.Set;

public final class TableStyleOptions {
    public static final int NONE = 0;
    public static final int FIRST_ROW = 32;
    public static final int LAST_ROW = 64;
    public static final int FIRST_COLUMN = 128;
    public static final int LAST_COLUMN = 256;
    public static final int ROW_BANDS = 512;
    public static final int COLUMN_BANDS = 1024;
    public static final int DEFAULT_2003 = 1536;
    public static final int DEFAULT = 672;
    public static final int length = 9;

    private TableStyleOptions() {
    }

    public static String getName(int tableStyleOptions) {
        switch (tableStyleOptions) {
            case 0: {
                return "NONE";
            }
            case 32: {
                return "FIRST_ROW";
            }
            case 64: {
                return "LAST_ROW";
            }
            case 128: {
                return "FIRST_COLUMN";
            }
            case 256: {
                return "LAST_COLUMN";
            }
            case 512: {
                return "ROW_BANDS";
            }
            case 1024: {
                return "COLUMN_BANDS";
            }
            case 1536: {
                return "DEFAULT_2003";
            }
            case 672: {
                return "DEFAULT";
            }
        }
        return "Unknown TableStyleOptions value.";
    }

    public static Set<String> getNames(int tableStyleOptions) {
        HashSet<String> hashSet = new HashSet<String>();
        if ((0 & tableStyleOptions) == 0) {
            hashSet.add("NONE");
        }
        if ((0x20 & tableStyleOptions) == 32) {
            hashSet.add("FIRST_ROW");
        }
        if ((0x40 & tableStyleOptions) == 64) {
            hashSet.add("LAST_ROW");
        }
        if ((0x80 & tableStyleOptions) == 128) {
            hashSet.add("FIRST_COLUMN");
        }
        if ((0x100 & tableStyleOptions) == 256) {
            hashSet.add("LAST_COLUMN");
        }
        if ((0x200 & tableStyleOptions) == 512) {
            hashSet.add("ROW_BANDS");
        }
        if ((0x400 & tableStyleOptions) == 1024) {
            hashSet.add("COLUMN_BANDS");
        }
        if ((0x600 & tableStyleOptions) == 1536) {
            hashSet.add("DEFAULT_2003");
        }
        if ((0x2A0 & tableStyleOptions) == 672) {
            hashSet.add("DEFAULT");
        }
        return hashSet;
    }

    public static String toString(int tableStyleOptions) {
        switch (tableStyleOptions) {
            case 0: {
                return "None";
            }
            case 32: {
                return "FirstRow";
            }
            case 64: {
                return "LastRow";
            }
            case 128: {
                return "FirstColumn";
            }
            case 256: {
                return "LastColumn";
            }
            case 512: {
                return "RowBands";
            }
            case 1024: {
                return "ColumnBands";
            }
            case 1536: {
                return "Default2003";
            }
            case 672: {
                return "Default";
            }
        }
        return TableStyleOptions.toStringSet(tableStyleOptions);
    }

    public static String toStringSet(int attr) {
        String string = "";
        String string2 = "";
        for (int n : TableStyleOptions.getValues()) {
            if (n == 0 || (n & attr) != n) continue;
            string = string + string2 + TableStyleOptions.toString(n);
            string2 = ", ";
        }
        return string;
    }

    public static int fromName(String tableStyleOptionsName) {
        if ("NONE".equals(tableStyleOptionsName)) {
            return 0;
        }
        if ("FIRST_ROW".equals(tableStyleOptionsName)) {
            return 32;
        }
        if ("LAST_ROW".equals(tableStyleOptionsName)) {
            return 64;
        }
        if ("FIRST_COLUMN".equals(tableStyleOptionsName)) {
            return 128;
        }
        if ("LAST_COLUMN".equals(tableStyleOptionsName)) {
            return 256;
        }
        if ("ROW_BANDS".equals(tableStyleOptionsName)) {
            return 512;
        }
        if ("COLUMN_BANDS".equals(tableStyleOptionsName)) {
            return 1024;
        }
        if ("DEFAULT_2003".equals(tableStyleOptionsName)) {
            return 1536;
        }
        if ("DEFAULT".equals(tableStyleOptionsName)) {
            return 672;
        }
        throw new IllegalArgumentException("Unknown TableStyleOptions name.");
    }

    public static int fromNames(Set<String> tableStyleOptionsNames) {
        int n = 0;
        for (String string : tableStyleOptionsNames) {
            n |= TableStyleOptions.fromName(string);
        }
        return n;
    }

    public static int[] getValues() {
        return new int[]{0, 32, 64, 128, 256, 512, 1024, 1536, 672};
    }
}

