/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzQC;
import com.aspose.words.internal.zzRv;
import com.aspose.words.internal.zzRz;
import com.aspose.words.internal.zzUw;
import com.aspose.words.internal.zzW6t;
import com.aspose.words.internal.zzW9L;
import com.aspose.words.internal.zzXfi;
import com.aspose.words.internal.zzXg0;
import com.aspose.words.internal.zzYNo;
import com.aspose.words.internal.zzYYv;
import com.aspose.words.internal.zzYyq;
import com.aspose.words.internal.zziu;
import com.aspose.words.zz94;
import com.aspose.words.zzBj;
import com.aspose.words.zzW8E;
import com.aspose.words.zzWBA;
import com.aspose.words.zzWIK;
import com.aspose.words.zzY8O;
import com.aspose.words.zzYq7;
import com.aspose.words.zzZ1Z;
import com.aspose.words.zzZ5e;
import com.aspose.words.zzZEQ;
import com.aspose.words.zzZiX;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzmP(zzRv zzRv2, zzRv zzRv3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzXg0.zzXa((Object)zzRv2, "srcStream");
        zzXg0.zzXa((Object)zzRv3, "dstStream");
        zzXg0.zzXa((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzXa(zzRv2, zzRv3, certificateHolder, signOptions);
        zzRv3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzmP(zzRv.zzXa(srcStream), (zzRv)zzRv.zzVT3(dstStream), certHolder, signOptions);
    }

    private static void zzXa(zzRv zzRv2, zzRv zzRv3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzVT3(digitalSignature);
        }
        if (zzZ1Z.zzXS2(zzRv2)) {
            DigitalSignatureUtil.zzmP(zzRv2, zzRv3, digitalSignature, true);
            return;
        }
        zzZ1Z zzZ1Z2 = new zzZ1Z();
        zzRv zzRv4 = zzRv2;
        zzZ1Z zzZ1Z3 = zzZ1Z2;
        FileFormatInfo fileFormatInfo = zzZ1Z2.zzXa(zzRv4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzQC zzQC2 = new zzQC(zzRv2);
                int n = fileFormatInfo.zzXKZ() == 1 ? 1 : 2;
                zzZ5e.zzmP(zzQC2, digitalSignature, n);
                zzRv3.zzEQ(0L);
                zzQC2.zzZsM(zzRv3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzmP(fileFormatInfo.zzXY(), zzRv3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzmP(zzRv2, zzRv3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzmP(zzRv2, zzRv3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzXg0.zzVT3(srcFileName, "srcFileName");
        zzXg0.zzVT3(dstFileName, "dstFileName");
        try (zzRz zzRz2 = zzXg0.zzXa(srcFileName, 3, 1);){
            try (zzRz zzRz3 = zzXg0.zzXa(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzmP((zzRv)zzRz2, (zzRv)zzRz3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzW6t zzW6t2 = zzRv.zzVT3(dstStream);
        zzRv zzRv2 = zzRv.zzXa(srcStream);
        DigitalSignatureUtil.zzmP(zzRv2, (zzRv)zzW6t2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzRz zzRz2 = zzXg0.zzXa(srcFileName, 3, 1);){
            try (zzRz zzRz3 = zzXg0.zzXa(dstFileName, 4, 2);){
                DigitalSignatureUtil.zz6t(zzRz2, zzRz3);
            }
            return;
        }
    }

    private static void zz6t(zzRv zzRv2, zzRv zzRv3) throws Exception {
        zzZ1Z zzZ1Z2 = new zzZ1Z();
        zzRv zzRv4 = zzRv2;
        Object object = zzZ1Z2;
        FileFormatInfo fileFormatInfo = zzZ1Z2.zzXa(zzRv4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzQC zzQC2 = new zzQC(zzRv2);
                zzQC2.zzZMa().zzWZ("_xmlsignatures");
                zzQC2.zzZMa().zzWZ("_signatures");
                zzRv3.zzYKx(0L);
                zzQC2.zzZsM(zzRv3);
                zzRv zzRv5 = zzRv3;
                zzRv5.zzEQ(zzRv5.zzXVO());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzYNo zzYNo2 = new zzYNo(zzRv2);
                zzXfi zzXfi2 = zzYNo2.zzmP(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXfi2 != null) {
                    for (zzUw zzUw2 : zzXfi2.zzax()) {
                        String string = zzXfi2.zzmP(zzUw2);
                        zzYNo2.zzYgt().remove(string);
                    }
                    zzYNo2.zzYgt().remove(zzXfi2.getName());
                    zzUw zzUw3 = zzYNo2.zzax().zzVQ6("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzYNo2.zzax().remove(zzUw3.getId());
                    zzYNo2.zzZM6();
                }
                zzRv3.zzYKx(0L);
                zzYNo2.zzZsM(zzRv3);
                zzRv zzRv6 = zzRv3;
                zzRv6.zzEQ(zzRv6.zzXVO());
                return;
            }
            case 60: 
            case 61: {
                zzBj zzBj2 = new zzBj(zzRv2);
                zzWIK zzWIK2 = zzBj2.zzZMy("/META-INF/documentsignatures.xml");
                if (zzWIK2 != null) {
                    zzBj2.zzZO7().remove(zzWIK2.getName());
                }
                zzRv3.zzYKx(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzRv4 = zzRv3;
                object = zzBj2;
                ((zzBj)object).zzmP(zzRv4, string, null);
                zzRv zzRv7 = zzRv3;
                zzRv7.zzEQ(zzRv7.zzXVO());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zz6t(zzRv.zzXa(srcStream), zzRv.zzVT3(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzRz zzRz2 = zzXg0.zzXa(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYj4(zzRz2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYj4(zzRv zzRv2) throws Exception {
        if (zzZ1Z.zzXS2(zzRv2)) {
            return DigitalSignatureUtil.zzX8w(zzRv2);
        }
        zzZ1Z zzZ1Z2 = new zzZ1Z();
        zzRv zzRv3 = zzRv2;
        zzZ1Z zzZ1Z3 = zzZ1Z2;
        FileFormatInfo fileFormatInfo = zzZ1Z2.zzXa(zzRv3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzRv2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYj4(zzRv.zzXa(stream));
    }

    static zzYYv zzmP(zzQC zzQC2, String string) throws Exception {
        zzYq7 zzYq72 = new zzYq7(zzQC2);
        if (zzYq72.zzYaf()) {
            zzYYv zzYYv2 = zzYq72.zzXId(string);
            return zzYYv2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzZG1(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzW9L.zzXa("Unexpected digest algorithm: {0}.", n));
    }

    static String zzYDO(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzZG1(n);
    }

    private static void zzmP(zzRv zzRv2, zzRv zzRv3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzYNo zzYNo2 = new zzYNo(zzRv2);
        zzWBA zzWBA2 = bl ? new zzZEQ(zzYNo2) : new zzY8O(zzYNo2);
        zzWBA2.zzXa(digitalSignature);
        zzRv3.zzEQ(0L);
        zzYNo2.zzZsM(zzRv3);
    }

    private static void zzmP(zzRv zzRv2, zzRv zzRv3, DigitalSignature digitalSignature) throws Exception {
        zzBj zzBj2 = new zzBj(zzRv2);
        zz94 zz942 = new zz94(zzBj2);
        zz942.zzXa(digitalSignature);
        zzRv3.zzEQ(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzRv zzRv4 = zzRv3;
        zzBj zzBj3 = zzBj2;
        zzBj3.zzmP(zzRv4, string, null);
    }

    private static void zzmP(zzQC zzQC2, zzRv zzRv2, DigitalSignature digitalSignature, String string) throws Exception {
        zzYYv zzYYv2 = DigitalSignatureUtil.zzmP(zzQC2, string);
        zzYYv zzYYv3 = new zzYYv();
        DigitalSignatureUtil.zzmP((zzRv)zzYYv2, (zzRv)zzYYv3, digitalSignature, false);
        zzQC zzQC3 = zzYq7.zz6t(zzYYv3, string);
        zzQC3.zzZsM(zzRv2);
    }

    private static DigitalSignatureCollection zzX8w(zzRv zzRv2) throws Exception {
        zzRv2.zzYKx(0L);
        zzYNo zzYNo2 = new zzYNo(zzRv2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXfi zzXfi2 = zzYNo2.zzmP(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXfi2 != null) {
            for (zzUw zzUw2 : zzXfi2.zzax()) {
                String string = zzXfi2.zzmP(zzUw2);
                zzXfi zzXfi3 = zzYNo2.zzWN7(string);
                zzXfi zzXfi4 = zzYNo2.zzmP(zzXfi3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzYyq zzYyq2 = zziu.zzZsM(zzXfi4.zzib().zzWLQ());
                zzW8E.zzmP(zzXfi3.zz6U(), zzYyq2, new zzZiX(zzYNo2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

