/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZe2;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zz5D;
import com.aspose.words.net.System.Data.zzVT3;
import com.aspose.words.net.System.Data.zzXa;
import com.aspose.words.net.System.Data.zzXcX;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzZdF;
    private final DataColumnCollection zzr7;
    private final ConstraintCollection zzZgO;
    private final zz5D zzYou;
    private ResultSet zzSA;
    private String zzXcy;
    private DataSet zzG0;
    private String zzWo9;
    private UniqueConstraint zzZKE;
    private boolean zzXvz;
    private final List<DataTableEventListener> zzuH;
    private final Set<DataRow> zz8r;
    private DataRelationCollection zzYsE;

    public DataTable() {
        this.zzZdF = new DataRowCollection(this);
        this.zzr7 = new DataColumnCollection(this);
        this.zzZgO = new ConstraintCollection(this);
        this.zzYou = new zz5D(this);
        this.zzWo9 = "";
        this.zzXvz = true;
        this.zzuH = new ArrayList<DataTableEventListener>();
        this.zz8r = new HashSet<DataRow>();
        this.zzYsE = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzZdF = new DataRowCollection(this);
        this.zzr7 = new DataColumnCollection(this);
        this.zzZgO = new ConstraintCollection(this);
        this.zzYou = new zz5D(this);
        this.zzWo9 = "";
        this.zzXvz = true;
        this.zzuH = new ArrayList<DataTableEventListener>();
        this.zz8r = new HashSet<DataRow>();
        this.zzYsE = new DataRelationCollection();
        this.zzXcy = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzXa.zzmP(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzZdF = new DataRowCollection(this);
        this.zzr7 = new DataColumnCollection(this);
        this.zzZgO = new ConstraintCollection(this);
        this.zzYou = new zz5D(this);
        this.zzWo9 = "";
        this.zzXvz = true;
        this.zzuH = new ArrayList<DataTableEventListener>();
        this.zz8r = new HashSet<DataRow>();
        this.zzYsE = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzSA = resultSet;
        this.zzXcy = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzSA != null) {
            if (this.zzSA.getStatement() != null) {
                this.zzSA.getStatement().getConnection().close();
            }
            this.zzSA = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXcy;
    }

    public void setTableName(String tableName) {
        this.zzXcy = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzr7.getCount();
    }

    public String getColumnName(int index) {
        return this.zzr7.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzSA;
    }

    public DataSet getDataSet() {
        return this.zzG0;
    }

    final void zzXf7(DataSet dataSet) {
        this.zzG0 = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzG0.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzYsE.add(dataRelation);
        }
        return this.zzYsE;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzG0.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzZdF;
    }

    public DataColumnCollection getColumns() {
        return this.zzr7;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzZgO;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzZKE == null) {
            return new DataColumn[0];
        }
        return this.zzZKE.getColumns();
    }

    final void zz5D(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzZKE != null) {
                this.zzZKE.zzPe(false);
                this.getConstraints().remove(this.zzZKE);
                this.zzZKE = null;
            }
            return;
        }
        if (this.zzZKE != null && DataColumn.areColumnSetsTheSame(value, this.zzZKE.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzmP(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzZKE != null) {
            this.zzZKE.zzPe(false);
            this.getConstraints().remove(this.zzZKE);
            this.zzZKE = null;
        }
        UniqueConstraint.zzmP(this.getConstraints(), uniqueConstraint);
        this.zzZKE = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzWo9;
    }

    public void setNamespace(String namespace) {
        this.zzWo9 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXvz;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXvz = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zz8r.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzXa.zzmP(this.getResultSet(), this);
            zzXa.zzXa(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzZe2.zzXf7(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzXa.zz6t(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzuH.contains(listener)) {
            this.zzuH.add(listener);
        }
    }

    public void removeEventListener(zzVT3 listener) {
        if (this.zzuH.contains(listener)) {
            this.zzuH.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzuH.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zz8r.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzuH) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zz8r.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzuH) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zz8r.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzuH) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzuH) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzuH) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXcX zzmP(zzXa[] zzXaArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzXaArray.length];
        for (int i = 0; i < zzXaArray.length; ++i) {
            dataColumnArray[i] = zzXaArray[i].zzZbU();
        }
        DataTable dataTable = this;
        zzXcX zzXcX2 = dataTable.zzYou.zzXf7(dataColumnArray);
        if (zzXcX2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXcX2;
    }

    final zz5D zzXLU() {
        return this.zzYou;
    }

    final Set<DataRow> zzW7W() {
        return this.zz8r;
    }
}

