/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzIr;
import com.aspose.words.internal.zzX8z;
import com.aspose.words.internal.zzXFg;
import com.aspose.words.internal.zzXWZ;
import com.aspose.words.internal.zzXaz;
import com.aspose.words.internal.zzY2c;
import com.aspose.words.internal.zzZ1s;
import com.aspose.words.internal.zzZ3z;
import com.aspose.words.internal.zzZ8z;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzXS4
extends CertPathBuilderSpi {
    private final zzIr zzYmt;
    private zzXFg zzXCv;

    zzXS4(zzIr zzIr2) {
        this.zzYmt = zzIr2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZ8z pkixParams;
        if (params instanceof zzZ8z) {
            pkixParams = (zzZ8z)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZ8z.zzmP((PKIXBuilderParameters)params).zzXBx();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZ8z.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZ1s zzZ1s2 = pkixParams.zzW4D().zzYSf();
        try {
            collection = zzXWZ.zzmP(zzZ1s2, pkixParams.zzW4D().zzXYs());
            collection.addAll(zzXWZ.zzmP(zzZ1s2, pkixParams.zzW4D().zzYGR()));
        }
        catch (zzXFg zzXFg2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzXFg2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzmP(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzXCv != null) {
            throw new CertPathBuilderException(this.zzXCv.getMessage(), this.zzXCv.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzmP(X509Certificate x509Certificate, zzZ8z zzZ8z2, List list) throws CertPathBuilderException {
        zzZ3z zzZ3z2;
        zzY2c zzY2c2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZ8z2.zzZS7().contains(x509Certificate)) {
            return null;
        }
        if (zzZ8z2.zzYgx() != -1 && list.size() - 1 > zzZ8z2.zzYgx()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzY2c2 = new zzY2c(this.zzYmt);
            zzZ3z2 = new zzZ3z(this.zzYmt);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzXWZ.zzmP(x509Certificate, zzZ8z2.zzW4D().zzYke(), zzZ8z2.zzW4D().zzXhY()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzY2c2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzXFg("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZ3z2.engineValidate(certPath, zzZ8z2);
                }
                catch (Exception exception) {
                    throw new zzXFg("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzX8z> arrayList = new ArrayList<zzX8z>();
            arrayList.addAll(zzZ8z2.zzW4D().zzXYs());
            try {
                arrayList.addAll(zzXWZ.zzmP(x509Certificate.getExtensionValue(zzXaz.zzZoa.getId()), zzZ8z2.zzW4D().zzZHq()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzXFg("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzXWZ.zzmP(x509Certificate, zzZ8z2.zzW4D().zzYGR(), arrayList));
            }
            catch (zzXFg zzXFg2) {
                throw new zzXFg("Cannot find issuer certificate for certificate in certification path.", zzXFg2);
            }
            if (hashSet.isEmpty()) {
                throw new zzXFg("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzmP(x509Certificate2, zzZ8z2, list);
            }
        }
        catch (zzXFg zzXFg3) {
            this.zzXCv = zzXFg3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

