/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzAl;
import com.aspose.words.internal.zzLH;
import com.aspose.words.internal.zzMj;
import com.aspose.words.internal.zzRv;
import com.aspose.words.internal.zzW9L;
import com.aspose.words.internal.zzWCo;
import com.aspose.words.internal.zzWFC;
import com.aspose.words.internal.zzWTp;
import com.aspose.words.internal.zzWXk;
import com.aspose.words.internal.zzX15;
import com.aspose.words.internal.zzXg0;
import com.aspose.words.internal.zzXwL;
import com.aspose.words.internal.zzXwR;
import com.aspose.words.internal.zzYYv;
import com.aspose.words.internal.zzYdl;
import com.aspose.words.internal.zzYnE;
import com.aspose.words.internal.zzZis;
import com.aspose.words.internal.zzw;
import com.aspose.words.zz0u;
import com.aspose.words.zz48;
import com.aspose.words.zzB1;
import com.aspose.words.zzBQ;
import com.aspose.words.zzRW;
import com.aspose.words.zzVYV;
import com.aspose.words.zzW0S;
import com.aspose.words.zzW2S;
import com.aspose.words.zzWDF;
import com.aspose.words.zzWHy;
import com.aspose.words.zzWRH;
import com.aspose.words.zzWd2;
import com.aspose.words.zzWe8;
import com.aspose.words.zzWeO;
import com.aspose.words.zzWj;
import com.aspose.words.zzXLi;
import com.aspose.words.zzXQE;
import com.aspose.words.zzXSe;
import com.aspose.words.zzXTd;
import com.aspose.words.zzXVy;
import com.aspose.words.zzXgu;
import com.aspose.words.zzXsx;
import com.aspose.words.zzXu4;
import com.aspose.words.zzXwO;
import com.aspose.words.zzYNX;
import com.aspose.words.zzYOX;
import com.aspose.words.zzYPj;
import com.aspose.words.zzYfo;
import com.aspose.words.zzYhy;
import com.aspose.words.zzYid;
import com.aspose.words.zzYkm;
import com.aspose.words.zzYvX;
import com.aspose.words.zzZ1s;
import com.aspose.words.zzZ51;
import com.aspose.words.zzZLG;
import com.aspose.words.zzZYo;
import com.aspose.words.zzZeA;
import com.aspose.words.zzZlF;
import com.aspose.words.zzeG;
import com.aspose.words.zzla;
import com.aspose.words.zzon;
import com.aspose.words.zzu9;
import com.aspose.words.zzvq;
import com.aspose.words.zzxL;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zz48,
zzBQ,
zzXLi,
zzZLG {
    private Document zzVRX;
    private Node zzXh0;
    private Node zzZyH;
    private zzWe8 zzXQZ;
    private Font zzZgm;
    private zzXwR<zzWe8> zzYBj;
    private zzXwR<zzXQE> zz3P;
    private zzXwR<zzmP> zzYTB;
    private zzXgu zzZg6 = zzXgu.zzXtz();
    private zzu9 zzXix = new zzu9();
    private zzXQE zzZcJ;
    private RowFormat zzI2;
    private CellFormat zzZ76;
    private ParagraphFormat zzZch;
    private zzXwR<zzYPj> zzWU2;
    private int zzWsy = 0;
    private int zzYGq = -1;
    private int zzYU7;
    private boolean zzX1q;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzWsc(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzWsc(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzWsc(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzmP(documentBuilder.getCurrentSection(), zzXSe.zzWPu(headerFooterType), 0, 0);
    }

    private void zzWsc(int n, int n2, int n3, int n4) {
        this.zzVRX.ensureMinimum();
        Section section = (Section)this.zzVRX.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzmP(section, 1, n3, n4);
    }

    private void zzmP(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzXSe.zz7T(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = section.appendChild(new HeaderFooter(this.zzVRX, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzVRX));
            }
        }
        this.zzmP(story, n2, n3);
    }

    private void zzmP(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzmP((CompositeNode)paragraph2, n3);
    }

    final void zzmP(Paragraph paragraph, int n) {
        this.zzmP((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzWbQ().zzVRd() ? zzXu4.zzXO5(this.zzVRX, fieldName) : zzXu4.zzke(this.zzWbQ(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzmP(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzmP(field, isAfter, false);
    }

    private boolean zzmP(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzWj zzWj2 = field.getFormat().zzNk();
        Inline inline = zzWj2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzmP(inline.zzXG3(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzYfo.zzmP(this.zzVRX, bookmarkName) : zzYfo.zzXa(this.zzVRX, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzXFH() == 6) {
            this.zzmP(node.zzYV0(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzXsx.zzvi(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzmP((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzmP(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzXa(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzmP(structuredDocumentTag);
            return;
        }
        this.zzVT3(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzXxo(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzmP((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzXFH() == 6) {
            this.zzYhQ(node);
        } else {
            Node node2 = node;
            if (zzXsx.zzYIX(node2.getNodeType())) {
                Paragraph paragraph = zzXsx.zzvi(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzYhQ(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzXFH() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzYhQ(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzYU7 = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzYpe();
            return;
        }
        if (!this.zzYog()) {
            this.zzYpe();
        }
    }

    private void zzmP(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzYog() {
        Node node = this.zzWbQ();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzWbQ().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzmP(((StructuredDocumentTag)documentBuilder.zzWbQ().getParentNode()).zzX8r(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzWbQ(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzmP(inline.zzXG3(), true);
            return true;
        }
        return false;
    }

    private void zzYpe() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzmP(documentBuilder.getCurrentParagraph().zzZAB(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzXxo(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzYPJ() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzWbQ().zzYC8(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzWcB();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzmP((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzXVy(text, false);
    }

    public void writeln(String text) {
        this.zzXVy(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzWbQ() != null && this.zzWbQ().zzXFH() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzWbQ().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzYsJ();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzB1 zzB12 = new zzB1(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzVRX, this.zzZzt(), this.zzWgZ());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().zz1h(paragraph);
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzXa(this.zzWbQ(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzB12.dispose();
        }
        if (this.getDocument().zzXxb()) {
            zzXsx.zzVT3((zzZlF)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzYrB());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzYTE() {
        zzWe8 zzWe82;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzYsJ();
        Node node = this.zzWbQ();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzX6y(false);
        } else {
            run2 = run = (Run)node.zzWFG(21);
        }
        if (run2 == null && zzXg0.zzXVi(node, paragraph.zzWQd())) {
            run = paragraph.zzWQd();
        }
        if (run != null) {
            cloneable = run.zzXG3();
            zzWe82 = (zzWe8)((zzW2S)cloneable).zzX6h();
        } else {
            cloneable = paragraph.zzZAB();
            zzWe82 = (zzWe8)((zzW2S)cloneable).zzX6h();
        }
        zzWe8 zzWe83 = zzWe82;
        Paragraph paragraph2 = new Paragraph(this.zzVRX, this.zzZzt(), zzWe83);
        paragraph.zzYES(paragraph2);
        zzB1 zzB12 = new zzB1(this.zzVRX);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzXa(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzB12.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXTd.zzXO5(this);
    }

    public void insertBreak(int breakType) {
        this.zzYtT(breakType, true);
    }

    final void zzYtT(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzZcO(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzYXz(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzXz8())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzZcO(bl)) {
                        this.zzYXz(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzZcO(bl)) {
                        this.zzWmc(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzZcO(bl)) {
                        this.zzWmc(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzZcO(bl)) {
                        this.zzWmc(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzZcO(bl)) {
                        this.zzWmc(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzZcO(bl)) {
                        this.zzWmc(4);
                    }
                    return;
                }
                case 8: {
                    this.zzYXz(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzMj.zzXOk(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzW9L.zzXa("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzYsJ();
        return zzXsx.zzmP(fieldType, updateField, this.zzWgZ(), this.zzZOu(), this.zzX58(), this.zzX58() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzYsJ();
        return zzXsx.zzmP(fieldCode, this.zzWgZ(), this.zzZOu(), this.zzX58(), this.zzX58() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzYsJ();
        return zzXsx.zzmP(fieldCode, fieldValue, this.zzWgZ(), this.zzZOu(), this.zzX58(), this.zzX58() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzXg0.zzXa((Object)displayText, "displayText");
        zzXg0.zzXa((Object)urlOrBookmark, "hrefOrBookmark");
        zzYid zzYid2 = this.zzXa(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        Object object = this;
        zzYid2.zzVT3(((DocumentBuilder)object).zzZh(88, true));
        object = zzYid2;
        return zzXsx.zzmP((zzYid)object);
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzhz(70);
        if (zzMj.zzXOk(name)) {
            this.startBookmark(name);
        }
        this.zzYTs(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzXVP(70);
        String string = zzMj.zzXOk(fieldValue) ? fieldValue : FormField.zzZh9;
        Run run = new Run(this.zzVRX, string, this.zzWgZ());
        this.insertNode(run);
        Node node = this.zzZh(70, true);
        if (zzMj.zzXOk(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzXv6(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzmP((CompositeNode)((Paragraph)node.zzYV0()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzhz(71);
        if (zzMj.zzXOk(name)) {
            this.startBookmark(name);
        }
        this.zzYTs(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzZh(71, false);
        if (zzMj.zzXOk(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXv6(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzhz(83);
        if (zzMj.zzXOk(name)) {
            this.startBookmark(name);
        }
        this.zzYTs(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzZh(83, false);
        if (zzMj.zzXOk(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXv6(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzVRX, footnoteType, !zzMj.zzXOk(referenceMark), referenceMark, this.zzWgZ());
        Style style = this.getDocument().getStyles().zz3K(zzXsx.zzZx2(footnoteType));
        footnote.zzXG3().set(50, style.zzWq1());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzVRX);
        Style style2 = this.getDocument().getStyles().zz3K(zzXsx.zzJR(footnoteType));
        paragraph.zzXgJ().set(1000, style2.zzWq1());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzVRX, '\u0002', new zzWe8()) : new Run(this.zzVRX, footnote.getReferenceMark(), new zzWe8());
        inline.zzXG3().set(50, style.zzWq1());
        paragraph.appendChild(inline);
        if (zzMj.zzXOk(footnoteText)) {
            Node node = this.zzWbQ();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYhQ(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzXhf(zzRv zzRv2) throws Exception {
        return this.zzmP(zzRv2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzXhf(zzRv.zzXa(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzmP(zzRv zzRv2, double d, double d2) throws Exception {
        return this.zzmP(zzRv2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzmP(zzRv.zzXa(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        zzYYv zzYYv2 = new zzYYv();
        try {
            zzWTp.zzmP(image, zzYYv2);
            Shape shape = this.zzmP(zzYYv2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zzYYv2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzXg0.zzVT3(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzWXk.zzVYB(fileName);
        try {
            Shape shape = this.zzmP((zzRv)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzRv)object).close();
            }
        }
    }

    private Shape zzmP(zzRv zzRv2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzRv2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzXg0.zzke(zzRv2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzmP(zzRv.zzXa(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzmP(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzmP(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzLH.zzY77(object)) {
            object4 = new zzWTp((byte[])object);
            bl2 = true;
            ((zzAl)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzVRX.getCompatibilityOptions().getMswVersion() > 12 || this.zzVRX.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzVRX, 0);
            object3 = new zzWd2();
            ((zzZeA)object3).zzmP(zzWHy.zzWHI("rect"));
            ((zzWd2)object3).zzmP(new zzRW());
            ((zzWd2)object3).zzWaJ().zzY8F().zzVT3(this.zzVRX);
            object2 = new zzYvX();
            ((zzeG)object2).zzXa(new zzW0S(this.zzVRX.zzYlU(), ""));
            ((zzeG)object2).zzmP(new zzxL());
            ((zzWeO)object3).zzmP((zzeG)object2);
            shape.setShapeType(75);
            shape.zzXcX((zzWeO)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzVRX, 75);
        }
        if (zzLH.zzXhf(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzmP((byte[])object, new zzZ51(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzZ51(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzLH.zzHF((byte[])object2));
                this.zzmP((zzWd2)shape.zzXRE(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzWd2)shape.zzXRE()).zzWaJ().zzY8F().zzZCV((byte[])object);
            object3 = zzLH.zz3G(object);
            object4 = new zzZ51(((zzXwL)object3).getWidthPoints(), ((zzXwL)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzXa(this.zzWgZ());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzLH.zzXuZ(object)) {
            d5 = DocumentBuilder.zzmP(shape, object);
        }
        shape.zzmP(d3, d4, (zzZ51)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzmP(Shape shape, byte[] byArray) throws Exception {
        int n = zzLH.zzXCR(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzXsx.zzio(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzXsx.zzZf2(n);
        return d;
    }

    private void zzmP(zzWd2 zzWd22, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzWd22.zzWaJ().zzY8F().getExtensions();
        zzYYv zzYYv2 = new zzYYv(byArray);
        try {
            object = zzXsx.zzmP(zzYYv2, this.zzVRX);
            ((zzZYo)object).zzZAk(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzZYo)object).zzaj();
            byArray2 = ((zzZYo)object).zzWX9(true);
        }
        finally {
            zzYYv2.close();
        }
        zzWd22.zzWaJ().zzY8F().setExtensions(new zzWCo<zzYkm>());
        object = zzYkm.zzmP(byArray2, this.zzVRX);
        zzWd22.zzWaJ().zzY8F().getExtensions().zzVT3(((zzYkm)object).getUri(), (zzYkm)object);
    }

    private Shape zzmP(zzRv zzRv2, String string, boolean bl, zzRv zzRv3) throws Exception {
        zzWDF zzWDF2 = zzWDF.zzWYh(string);
        Shape shape = this.zzmP(zzRv3, bl, zzWDF2, null);
        zzYOX zzYOX2 = zzZ1s.zzmP(zzRv2, string, bl);
        return DocumentBuilder.zzmP(null, false, shape, zzWDF2.zzYNy, zzYOX2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzmP(zzRv.zzXa(stream), progId, asIcon, zzRv.zzXa(presentation));
    }

    private Shape zzmP(String string, boolean bl, boolean bl2, zzRv zzRv2) throws Exception {
        zzWDF zzWDF2 = zzWDF.zzXzD(zzYdl.zzW3Q(string));
        return this.zzmP(string, bl, bl2, zzRv2, zzWDF2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzmP(fileName, isLinked, asIcon, zzRv.zzXa(presentation));
    }

    private Shape zzmP(String string, String string2, boolean bl, boolean bl2, zzRv zzRv2) throws Exception {
        zzWDF zzWDF2 = zzWDF.zzWYh(string2);
        return this.zzmP(string, bl, bl2, zzRv2, zzWDF2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzmP(fileName, progId, isLinked, asIcon, zzRv.zzXa(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWDF zzWDF2 = zzWDF.zzXzD(zzYdl.zzW3Q(fileName));
        return this.zzmP(fileName, isLinked, iconFile, iconCaption, zzWDF2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWDF zzWDF2 = zzWDF.zzWYh(progId);
        return this.zzmP(fileName, isLinked, iconFile, iconCaption, zzWDF2);
    }

    private Shape zzXa(zzRv zzRv2, String string, String string2, String string3) throws Exception {
        zzWDF zzWDF2 = zzWDF.zzWYh(string);
        Shape shape = this.zzmP(string2, string3, zzWDF2);
        zzYOX zzYOX2 = zzZ1s.zzmP(zzRv2, string, true);
        return DocumentBuilder.zzmP(null, false, shape, zzWDF2.zzYNy, zzYOX2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzXa(zzRv.zzXa(stream), progId, iconFile, iconCaption);
    }

    final Shape zzmP(zzYNX zzYNX2, zzRv zzRv2) throws Exception {
        Shape shape = this.zzYIe(zzRv2);
        shape.setShapeType(201);
        shape.zzZ7Z(4112, zzYNX2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzYsJ();
        if (this.zzYcb()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzVa(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzVYV zzVYV2 = zzXsx.zzmP(html, options, this);
        zzVYV2.zzYB9();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzYsJ();
        return zzXsx.zzmP(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzYsJ();
        return zzXsx.zzmP(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zz0u zz0u2 = new zz0u();
        return zz0u2.zzmP(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWRH(this).zzmP(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzWRH(this).zzmP(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzVRX, 75);
        shape.zzXa(this.zzWgZ());
        shape.zzXS7(true);
        shape.getSignatureLine().zzmP(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzVN(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzXim(this.zzVRX);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzYcb() {
        boolean bl = false;
        if (this.zzWbQ().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzWbQ().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzVa(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzYsJ();
        if (this.zzYPJ() == null) {
            this.startTable();
        }
        if (this.zzYPJ().zzXVK() == 1) {
            this.zzYPJ().zzZr();
        }
        if (this.zzYPJ().zzXVK() == 3) {
            this.zzYPJ().zzXRT();
        }
        return this.zzYPJ().zzWrg();
    }

    public Table startTable() {
        this.zzWU2.push(new zzYPj(this));
        return this.zzYPJ().startTable();
    }

    public Table endTable() {
        if (this.zzYPJ() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzYPJ().endTable();
        this.zzWU2.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzYPJ() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzYPJ().endRow();
        if (this.zzZgm != null && this.zzZgm.getHidden()) {
            row.zzVVD().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzVRX, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzVRX, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZ1();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzVRX, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzZjd();
        bookmarkStart.zzW6g(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZ1();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzZjd();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzVRX, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzCY(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzVRX);
        this.zzYGq = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzYGq == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzVRX, this.zzYGq);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzVRX, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzXg0.zzXa((Object)importFormatOptions, "ImportFormatOptions");
        this.zzYsJ();
        return zzvq.zzmP(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Node insertDocumentInline(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzXg0.zzXa((Object)importFormatOptions, "ImportFormatOptions");
        this.zzYsJ();
        importFormatOptions.zzXnI(true);
        Node node = zzvq.zzmP(this, srcDoc, importFormatMode, importFormatOptions);
        importFormatOptions.zzXnI(false);
        return node;
    }

    public Document getDocument() {
        return this.zzVRX;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzVRX) {
            return;
        }
        this.zzVRX = value;
        this.zzYhQ(null);
        this.zzXQZ = new zzWe8();
        this.zzYBj = null;
        this.zz3P = null;
        this.zzZgm = null;
        this.zzWU2 = new zzXwR();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZgm == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZgm = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzZgm;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzZch == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZch = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzZch;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzI2 == null) {
            this.zzI2 = new RowFormat(this);
        }
        return this.zzI2;
    }

    public CellFormat getCellFormat() {
        if (this.zzZ76 == null) {
            this.zzZ76 = new CellFormat(this);
        }
        return this.zzZ76;
    }

    final void zzYKx(Node node) {
        this.getCurrentParagraph().zzYES(node);
    }

    public void pushFont() {
        zzWe8 zzWe82;
        if (this.getCurrentParagraph() != null) {
            zzWe8 zzWe83 = this.getCurrentParagraph().zzZAB();
            zzWe82 = (zzWe8)zzWe83.zzX6h();
        } else {
            zzWe82 = this.zzWgZ();
        }
        zzWe8 zzWe84 = zzWe82;
        this.zzZo2().push(new zzmP(this.zzWgZ(), zzWe84));
    }

    public void popFont() {
        zzXwR<zzmP> zzXwR2 = this.zzZo2();
        if (zzXwR2.size() > 0) {
            zzmP zzmP2 = (zzmP)this.zzZo2().pop();
            this.zzmP(zzmP2.zzXG3(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXv6(zzmP2.zzNQ());
            }
        }
    }

    final void zzYvo() {
        this.zzXes().push(this.zzWgZ());
    }

    final void zzZoh() {
        zzXwR<zzWe8> zzXwR2 = this.zzXes();
        if (zzXwR2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzmP((zzWe8)documentBuilder.zzXes().pop(), false);
        }
    }

    final void zzZfa() {
        this.zzX6v().push(this.zzZzt());
    }

    final void zzXfY() {
        zzXwR<zzXQE> zzXwR2 = this.zzX6v();
        if (zzXwR2.size() > 0) {
            zzXQE zzXQE2 = (zzXQE)this.zzX6v().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzmP(zzXQE2);
            }
        }
    }

    private zzYid zzXa(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzhz(88);
        zzon zzon2 = new zzon();
        zzon2.setTarget(string2);
        zzon2.setScreenTip(string3);
        if (bl) {
            zzon2.setSubAddress(string);
        } else {
            zzon2.setAddress(zzX15.zzZcN(string));
            zzon2.setSubAddress(zzX15.zzZZy(string));
        }
        this.zzYTs(zzon2.zzYbV());
        FieldSeparator fieldSeparator = this.zzXVP(88);
        return new zzYid(fieldStart, fieldSeparator, null);
    }

    final zzYid zzZtY(String string, String string2, String string3) {
        boolean bl = zzX15.zzXid(string);
        String string4 = bl ? zzX15.zzZZy(string) : string;
        return this.zzXa(string4, bl, string2, string3);
    }

    final zzYid zzmP(zzon zzon2) {
        FieldStart fieldStart = this.zzhz(88);
        this.zzYTs(zzon2.zzYbV());
        FieldSeparator fieldSeparator = this.zzXVP(88);
        return new zzYid(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzWk5() {
        return this.zzZh(88, true);
    }

    final zzWe8 zzWgZ() {
        zzWe8 zzWe82 = this.zzXQZ;
        return (zzWe8)zzWe82.zzX6h();
    }

    final zzXQE zzZzt() {
        zzXQE zzXQE2 = this.zzXgJ();
        return (zzXQE)zzXQE2.zzX6h();
    }

    final zzXgu zzZeR() {
        zzXgu zzXgu2 = this.zzVVD();
        return (zzXgu)zzXgu2.zzX6h();
    }

    final zzu9 zzZUS() {
        zzu9 zzu92 = this.zzZ1F();
        return (zzu9)zzu92.zzX6h();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzWbQ(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzWbQ().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzX1q && this.zzWbQ().getNodeType() == 28;
    }

    private void zzXVy(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzWbQ()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzXSe.zzvd(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzXwL(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWsy) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzYXz(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzXwL(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzYsJ();
        if (this.zzYPJ() != null && this.zzYPJ().zzXVK() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzWbQ().zzYES(node);
    }

    final void zzY0a(int n) {
        this.zzZcO(true);
        this.zzWmc(n);
    }

    private void zzWmc(int n) {
        this.insertParagraph();
        zzB1 zzB12 = new zzB1(this.getDocument());
        try {
            zzXwO zzXwO2 = this.getCurrentSection().zzZ8h();
            zzXwO zzXwO3 = (zzXwO)zzXwO2.zzX6h();
            Section section = new Section(this.zzVRX, zzXwO3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzVRX));
            this.zzVRX.insertAfter(section, this.getCurrentSection());
            section.getBody().zzXa(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzB12.dispose();
        }
    }

    final FieldStart zzhz(int n) {
        this.zzYsJ();
        return zzXsx.zzmP(n, this.zzWgZ(), this.zzZOu(), this.zzX58(), this.zzX58() == null);
    }

    final Run zzYTs(String string) {
        return zzXsx.zzXa(string, this.zzWgZ(), this.zzZOu(), this.zzX58(), this.zzX58() == null);
    }

    final FieldEnd zzZh(int n, boolean bl) {
        return zzXsx.zzXa(n, bl, this.zzWgZ(), this.zzZOu(), this.zzX58(), this.zzX58() == null);
    }

    final FieldSeparator zzXVP(int n) {
        return zzXsx.zzXa(n, this.zzWgZ(), this.zzZOu(), this.zzX58(), this.zzX58() == null);
    }

    private FormField zzXv6(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzVRX, new zzYhy(), this.zzWgZ());
        CompositeNode compositeNode = node == null ? this.zzZOu() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzZcO(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzYPJ() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzXxo(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzXwL(String string) {
        if (this.zzLH(string)) {
            zzw zzw2 = new zzw(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYnE zzYnE2 : zzw2.zz2C(this.getParagraphFormat().getBidi())) {
                zzXVy zzXVy2 = zzXVy.zzTG(zzYnE2.zzXxg());
                zzWe8 zzWe82 = this.zzWgZ();
                zzWe82.zzZqs(265, zzXVy2);
                if (zzYnE2.zzXFv()) {
                    zzWe82.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzVRX, zzYnE2.getText(), zzWe82);
                this.insertNode(run);
            }
            return;
        }
        this.zzYXz(string);
    }

    private boolean zzLH(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzZis.zzW4f(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzmP(zzWe8 zzWe82, boolean bl) {
        zzWe8 zzWe83;
        if (bl) {
            zzWe8 zzWe84 = zzWe82;
            zzWe83 = (zzWe8)zzWe84.zzX6h();
        } else {
            zzWe83 = zzWe82;
        }
        this.zzXQZ = zzWe83;
    }

    final void zzXZa() {
        this.zzXQZ.clear();
    }

    final void zzZsT() {
        if (this.zzZ1() != null) {
            zzu9 zzu92;
            zzu9 zzu93 = zzu92 = this.zzZ1().zzZ1F();
            this.zzXix = (zzu9)zzu93.zzX6h();
            zzu92.zzXa(this.zzXix);
        }
    }

    private Shape zzmP(String string, boolean bl, boolean bl2, zzRv zzRv2, zzWDF zzWDF2) throws Exception {
        if (zzWDF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzmP(zzRv2, bl2, zzWDF2, string);
        zzYOX zzYOX2 = zzZ1s.zzmP(string, bl, bl2, zzWDF2);
        return DocumentBuilder.zzmP(string, bl, shape, zzWDF2.zzYNy, zzYOX2);
    }

    private Shape zzmP(String string, boolean bl, String string2, String string3, zzWDF zzWDF2) throws Exception {
        if (zzWDF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzYdl.zzX2n(string);
        }
        Shape shape = string2 != null ? this.zzWhW(string2, string3) : this.zzmP(null, string3, zzWDF2);
        zzYOX zzYOX2 = zzZ1s.zzmP(string, bl, true, zzWDF2);
        return DocumentBuilder.zzmP(string, bl, shape, zzWDF2.zzYNy, zzYOX2);
    }

    private static Shape zzmP(String string, boolean bl, Shape shape, String string2, zzYOX zzYOX2) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzXa(zzYOX2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzmP(zzRv zzRv2, boolean bl, zzWDF zzWDF2, String string) throws Exception {
        if (zzWDF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzRv2 != null) {
            return this.zzYIe(zzRv2);
        }
        if (!bl) {
            return this.zzW8k(zzZ1s.zzYqO().get("normal"));
        }
        String string2 = string != null ? zzYdl.zzX2n(string) : zzZ1s.zzXPV(zzWDF2.zzRu);
        return this.zzmP(zzWDF2, string2);
    }

    private Shape zzmP(String string, String string2, zzWDF zzWDF2) throws Exception {
        if (zzWDF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzZ1s.zzXPV(zzWDF2.zzRu);
        }
        if (string != null) {
            return this.zzWhW(string, string2);
        }
        return this.zzmP(zzWDF2, string2);
    }

    private Shape zzmP(zzWDF zzWDF2, String string) throws Exception {
        if (zzWDF2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzZ1s.zzUW(zzWDF2.zzRu);
        zzWFC zzWFC2 = new zzWFC(byArray, null, string, this.getDocument().zzVYo());
        return this.zzW8k(zzWFC2.zzYz7());
    }

    private Shape zzWhW(String string, String string2) throws Exception {
        zzWFC zzWFC2 = new zzWFC(string, string2, this.getDocument().zzVYo());
        return this.zzW8k(zzWFC2.zzYz7());
    }

    private Shape zzYIe(zzRv zzRv2) throws Exception {
        byte[] byArray = zzXg0.zzke(zzRv2);
        return this.zzW8k(byArray);
    }

    private Shape zzW8k(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzVRX, 1);
        shape.setShapeType(75);
        shape.zzXa(this.zzWgZ());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzVN(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzmP(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzXa(compositeNode, n);
            return;
        }
        this.zzVT3(compositeNode, n);
    }

    private void zzXa(CompositeNode compositeNode, int n) {
        zzla zzla2 = zzla.zzXVy(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzla2.zzmP(null, true, true, true, false, true);
            node = zzla2.getNode();
            if (zzla2.zzYTz() && (!node.isComposite() || node.zzXFH() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzYWo().length() : node.getTextLength();
            if (!zzla2.zzYTz() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzla2.zzYTz() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzmP((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzmP(null, node);
            this.zzYU7 = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzmP(StructuredDocumentTag structuredDocumentTag) {
        this.zzYhQ(structuredDocumentTag);
        this.zzX1q = true;
        this.zzYU7 = 0;
        zzWe8 zzWe82 = structuredDocumentTag.zzX8r();
        switch (structuredDocumentTag.zzXFH()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzQe(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzWe82 = ((Inline)node).zzXG3();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzWe82 = paragraph.zzZAB();
                break;
            }
            default: {
                return;
            }
        }
        this.zzmP(zzWe82, true);
    }

    private void zzVT3(CompositeNode compositeNode, int n) {
        zzla zzla2 = zzla.zzYnA(compositeNode);
        while (zzla2.getNode() != compositeNode || !zzla2.zzYTz()) {
            int n2;
            Node node = zzla2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzYWo().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzmP(null, node);
                this.zzYU7 = n;
                return;
            }
            while (zzla2.zzmP(null, false, true, true, false, true) && zzla2.zzYTz() && zzla2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzYsJ() {
        int n = this.zzYU7;
        if (n == 0) {
            return;
        }
        this.zzYU7 = 0;
        Run run = zzXg0.zzmP((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zz4t(n);
        }
    }

    private Run zzYXz(String string) {
        Run run = new Run(this.zzVRX, string, this.zzWgZ());
        this.insertNode(run);
        return run;
    }

    final boolean zzWMO() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzwp() {
        return this.zzWsy;
    }

    final void zzWku(int n) {
        this.zzWsy = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzWbQ();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzWbQ();
        }
        return (Paragraph)this.zzWbQ().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzWbQ();
        }
        return (StructuredDocumentTag)this.zzWbQ().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzWbQ().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYPj zzYPJ() {
        return zzXg0.zzmP(this.zzWU2);
    }

    private Cell zzZ1() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzVu();
    }

    private CompositeNode zzZOu() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzWbQ();
        }
        return this.zzWbQ().getParentNode();
    }

    private Node zzX58() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzWbQ();
    }

    private zzXwR<zzWe8> zzXes() {
        if (this.zzYBj == null) {
            this.zzYBj = new zzXwR();
        }
        return this.zzYBj;
    }

    private zzXwR<zzXQE> zzX6v() {
        if (this.zz3P == null) {
            this.zz3P = new zzXwR();
        }
        return this.zz3P;
    }

    private zzXwR<zzmP> zzZo2() {
        if (this.zzYTB == null) {
            this.zzYTB = new zzXwR();
        }
        return this.zzYTB;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXQZ.zzXa9(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzXQZ.zzYdE(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzYKf(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzYKf(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXQZ.zzZqs(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZZi()) {
            this.getCurrentParagraph().zzZAB().zzZqs(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXQZ.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXQZ.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZZi()) {
            this.getCurrentParagraph().zzZAB().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzXgJ().zzXa9(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzXgJ().zzYdE(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zziu(key, 0);
        }
        return this.getDocument().getStyles().zz7j().zzZ31(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzXgJ().zzZqs(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzXgJ().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzXgJ().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzVVD().zzXa9(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzVVD().zzZ31(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzVVD().zzWUh(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzVVD().zzZqs(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzVVD().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzVVD().clear();
        zzXgu.zzXtz().zzXa(this.zzVVD());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZ1F().zzXa9(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZ1F().zzZ31(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZ1F().zzWUh(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzXg0.zzmP(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzZ1() != null ? this.zzZ1().getCellFormat() : this.getCellFormat();
            border.zzmP(cellFormat);
        }
        this.zzZ1F().zzZqs(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZ1F().clear();
    }

    private Node zzWbQ() {
        Node node = this.zzXh0 != null && this.zzXh0.getParentNode() == null ? this.zzZyH : this.zzXh0;
        if (node != null && node.zzXFH() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzX1q = this.zzX1q && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzYhQ(Node node) {
        this.zzXh0 = node;
        if (this.zzXh0 != null) {
            this.zzZyH = this.zzXh0.getParentNode();
        }
        this.zzX1q = false;
    }

    private zzXQE zzXgJ() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzXgJ();
        }
        if (this.zzZcJ == null) {
            this.zzZcJ = new zzXQE();
        }
        return this.zzZcJ;
    }

    private zzXgu zzVVD() {
        if (this.zzYPJ() != null && this.zzYPJ().zzXVK() == 1) {
            return this.zzZg6;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzVVD();
        }
        return this.zzZg6;
    }

    private zzu9 zzZ1F() {
        if (this.zzYPJ() != null && this.zzYPJ().zzXVK() != 3) {
            return this.zzXix;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzVu().zzZ1F();
        }
        return this.zzXix;
    }

    static final class zzmP {
        private zzWe8 zzXQZ;
        private zzWe8 zzXqK;

        public zzmP(zzWe8 zzWe82, zzWe8 zzWe83) {
            this.zzXQZ = zzWe82;
            this.zzXqK = zzWe83;
        }

        public final zzWe8 zzXG3() {
            return this.zzXQZ;
        }

        public final zzWe8 zzNQ() {
            return this.zzXqK;
        }
    }
}

