/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzXg0;
import com.aspose.words.zz6H;
import com.aspose.words.zzB1;
import com.aspose.words.zzHR;
import com.aspose.words.zzWA5;
import com.aspose.words.zzXsx;
import com.aspose.words.zzYVV;
import com.aspose.words.zzYzL;
import com.aspose.words.zzZl7;
import com.aspose.words.zzhS;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzHR,
Iterable<V> {
    private Node zzVTI;
    private Node zzKv;
    private Node zzIU;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzYzL zzYzL2 = new zzYzL(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzXf7(this, true);
            return;
        }
        finally {
            zzYzL2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzZNL() {
        return this.zzWor() != null;
    }

    final boolean zzMy() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzWWR() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzWA5) {
                return true;
            }
            CompositeNode compositeNode = zzXg0.zzmP((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzWWR()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzVTI;
    }

    public Node getLastChild() {
        return this.zzKv;
    }

    final Node zzWor() {
        return zzXsx.zzWsc(this.getFirstChild(), false);
    }

    final Node zzWaO() {
        return zzXsx.zzZqs(this.getLastChild(), false);
    }

    final CompositeNode zzX0K() {
        return (CompositeNode)zzXsx.zzWsc(this.getFirstChild(), true);
    }

    final CompositeNode zzZZO() {
        return (CompositeNode)zzXsx.zzZqs(this.getLastChild(), true);
    }

    final Node zzYsk() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzXsx.zzYIX((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzQe() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzXsx.zzYIX((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzmP(boolean bl, zzZl7 zzZl72) {
        CompositeNode compositeNode = (CompositeNode)super.zzmP(bl, zzZl72);
        ((CompositeNode)super.zzmP(bl, zzZl72)).zzKv = null;
        compositeNode.zzVTI = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzZsM(node.zzmP(true, zzZl72));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZCn(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZCn(StringBuilder stringBuilder) {
        this.zzWjo(stringBuilder);
        zzXg0.zzXa(stringBuilder, this.zzYWo());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzXa(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzXsx.zzWU5(nodeType);
            Node node2 = node = bl ? this.zzWor() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzWIl() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzhS.zzVT3(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzhS.zzXf7(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zz6H(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzmP(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzmP(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzXf7(oldChild, false);
    }

    private <T extends Node> T zzXf7(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = zzXsx.zzmP(documentBase, t, (Node)this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzXxb() && zzXsx.zzYoL(t)) {
            return t;
        }
        zzXsx.zzmP(documentBase, nodeChangingArgs);
        if (!bl && zzXsx.zzZVm(t)) {
            zzXsx.zzYab(t, false);
        }
        T t2 = this.zz4u(t);
        zzXsx.zzXa(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzYVV.zzZUL(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzZsM(Node node) {
        node.getParentNode();
        if (this.zzKv == null) {
            node.zzWLS(null);
            node.zzZlw(null);
            this.zzVTI = node;
        } else {
            node.zzWLS(this.zzKv);
            node.zzZlw(null);
            this.zzKv.zzZlw(node);
        }
        this.zzKv = node;
        node.zzWN7(this);
        return node;
    }

    final void zzmP(Node node, Node node2, Node node3) {
        this.zzmP(node, node2, node3, false);
    }

    final void zzmP(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzXcX(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzXa(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zz6t(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzXsx.zzYIX(node3.getNodeType())) continue;
            if (zzXsx.zzXcX(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzYWo().length();
    }

    String zzYWo() {
        return "";
    }

    final String zzXT4() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWjo(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzWjo(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZCn(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzXcX(Node node) {
        return true;
    }

    final <T extends Node> T zzmP(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYC8(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        zzXsx.zzXa(documentBase, documentBase2);
        if (t.getNodeType() != 37 && !this.zzXcX(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzB1(documentBase);
            try {
                compositeNode.zzXf7(t, true);
            }
            finally {
                ((zzB1)object).dispose();
            }
        }
        object = zzXsx.zzmP(documentBase, t, null, (Node)this, 0);
        zzXsx.zzmP(documentBase, (NodeChangingArgs)object);
        if (this.zzKv == null) {
            t.zzWLS(null);
            t.zzZlw(null);
            this.zzVTI = t;
            this.zzKv = t;
        } else if (bl) {
            if (node != null) {
                this.zzXa(t, node);
            } else {
                this.zzVT3(t, this.zzVTI);
            }
        } else if (node != null) {
            this.zzVT3(t, node);
        } else {
            this.zzXa(t, this.zzKv);
        }
        t.zzWN7(this);
        zzXsx.zzXa(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzXxb()) {
            zzXsx.zzmP(t, compositeNode, node2);
        }
        return t;
    }

    private void zzXa(Node node, Node node2) {
        Node node3 = node2.zzWGo();
        node.zzWLS(node2);
        node.zzZlw(node3);
        node2.zzZlw(node);
        if (node3 == null) {
            this.zzKv = node;
            return;
        }
        node3.zzWLS(node);
    }

    private void zzVT3(Node node, Node node2) {
        Node node3 = node2.zzZYu();
        node.zzWLS(node3);
        node.zzZlw(node2);
        node2.zzWLS(node);
        if (node3 == null) {
            this.zzVTI = node;
            return;
        }
        node3.zzZlw(node);
    }

    private <T extends Node> T zz4u(T t) {
        if (t == this.zzVTI) {
            if (this.zzVTI == this.zzKv) {
                this.zzVTI = null;
                this.zzKv = null;
            } else {
                this.zzVTI = t.zzWGo();
                this.zzVTI.zzWLS(null);
            }
        } else {
            Node node = t.zzZYu();
            Node node2 = t.zzWGo();
            node.zzZlw(node2);
            if (node2 == null) {
                this.zzKv = node;
            } else {
                node2.zzWLS(node);
            }
        }
        t.zzZlw(null);
        t.zzWLS(null);
        t.zzWN7(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzIU = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzIU;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

