/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYiy;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzYih = new ArrayList();
    private final Map<String, DataColumn> zzWop = new HashMap<String, DataColumn>();
    private DataTable zzXcV;

    DataColumnCollection(DataTable table) {
        this.zzXcV = table;
    }

    public void add(DataColumn column) {
        if (zzYiy.zzzz(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzYVt(column.getColumnName());
        if (this.zzWop.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzX2p(this.zzXcV);
        column.setOrdinal(this.zzYih.size());
        this.zzYih.add(column);
        this.zzWop.put(string, column);
        this.zzXcV.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzXcV);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzXcV);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzYiy.zzzz(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzYVt(columnName);
        DataColumn dataColumn = this.zzWop.get(string);
        if (dataColumn != null) {
            int n = this.zzYih.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzYih.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzYih.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzYih.remove(n);
            this.zzWop.remove(DataColumnCollection.zzYVt(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzXcV.getRows()) {
                dataRow.remove(n);
            }
            this.zzXcV.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzYih.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzYih.iterator();
    }

    public void clear() {
        this.zzWop.clear();
        this.zzYih.clear();
    }

    final DataColumn[] zzWo() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzYih);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzYl6(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzYih.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzYih.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzYVt(string);
            String string3 = DataColumnCollection.zzYVt(dataColumn.getColumnName());
            this.zzWop.remove(string3);
            this.zzWop.put(string2, dataColumn);
            return;
        }
    }

    private static String zzYVt(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

