/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzJV;
import com.aspose.words.internal.zzWFF;
import com.aspose.words.internal.zzWfK;
import com.aspose.words.internal.zzXE2;
import com.aspose.words.internal.zzXb8;
import com.aspose.words.internal.zzY4N;
import com.aspose.words.internal.zzYQD;
import com.aspose.words.internal.zzZSl;
import com.aspose.words.internal.zzmV;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzX3
extends CertPathBuilderSpi {
    private final zzWfK zzZBm;
    private zzXb8 zzY14;

    zzX3(zzWfK zzWfK2) {
        this.zzZBm = zzWfK2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzXE2 pkixParams;
        if (params instanceof zzXE2) {
            pkixParams = (zzXE2)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzXE2.zzYl6((PKIXBuilderParameters)params).zzWFb();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzXE2.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzYQD zzYQD2 = pkixParams.zzWR6().zzWiy();
        try {
            collection = zzJV.zzYl6(zzYQD2, pkixParams.zzWR6().zzZ2Q());
            collection.addAll(zzJV.zzYl6(zzYQD2, pkixParams.zzWR6().zzWUc()));
        }
        catch (zzXb8 zzXb82) {
            throw new CertPathBuilderException("Error finding target certificate.", zzXb82);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzYl6(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzY14 != null) {
            throw new CertPathBuilderException(this.zzY14.getMessage(), this.zzY14.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzYl6(X509Certificate x509Certificate, zzXE2 zzXE22, List list) throws CertPathBuilderException {
        zzY4N zzY4N2;
        zzZSl zzZSl2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzXE22.zzZ0B().contains(x509Certificate)) {
            return null;
        }
        if (zzXE22.zzXIh() != -1 && list.size() - 1 > zzXE22.zzXIh()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZSl2 = new zzZSl(this.zzZBm);
            zzY4N2 = new zzY4N(this.zzZBm);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzJV.zzYl6(x509Certificate, zzXE22.zzWR6().zzWgP(), zzXE22.zzWR6().zzZRG()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZSl2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzXb8("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzY4N2.engineValidate(certPath, zzXE22);
                }
                catch (Exception exception) {
                    throw new zzXb8("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzWFF> arrayList = new ArrayList<zzWFF>();
            arrayList.addAll(zzXE22.zzWR6().zzZ2Q());
            try {
                arrayList.addAll(zzJV.zzYl6(x509Certificate.getExtensionValue(zzmV.zzWP5.getId()), zzXE22.zzWR6().zzYgY()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzXb8("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzJV.zzYl6(x509Certificate, zzXE22.zzWR6().zzWUc(), arrayList));
            }
            catch (zzXb8 zzXb82) {
                throw new zzXb8("Cannot find issuer certificate for certificate in certification path.", zzXb82);
            }
            if (hashSet.isEmpty()) {
                throw new zzXb8("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzYl6(x509Certificate2, zzXE22, list);
            }
        }
        catch (zzXb8 zzXb83) {
            this.zzY14 = zzXb83;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

