/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzXSy;
import com.aspose.words.internal.zzYiy;
import com.aspose.words.zzXU7;
import com.aspose.words.zzXme;
import com.aspose.words.zzYrp;

public final class Section
extends CompositeNode<Node>
implements zzYrp {
    private zzXU7 zzMp;
    private PageSetup zzXGC;
    private HeaderFooterCollection zzWrP;

    public Section(DocumentBase doc) {
        this(doc, new zzXU7());
    }

    Section(DocumentBase doc, zzXU7 sectPr) {
        super(doc);
        this.zzMp = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzWrP == null) {
            this.zzWrP = new HeaderFooterCollection(this);
        }
        return this.zzWrP;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXGC == null) {
            Section section = this;
            this.zzXGC = new PageSetup(section, section.getDocument().zzX3t(), this.getDocument().getStyles(), new zzYl6(this));
        }
        return this.zzXGC;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzYzk();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzWxU(!value);
    }

    final zzXU7 zzZ5r() {
        return this.zzMp;
    }

    final void zzYJv(zzXU7 zzXU72) {
        this.zzMp = zzXU72;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzYl6(boolean bl, zzXme zzXme2) {
        zzXU7 zzXU72;
        Section section = (Section)super.zzYl6(bl, zzXme2);
        zzXU7 zzXU73 = this.zzMp;
        section.zzMp = zzXU72 = (zzXU7)zzXU73.zzW7g();
        section.zzXGC = null;
        section.zzWrP = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYl6(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzEr(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzX2p(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzX2p(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzrv(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzlE(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzrv(n) == null;
            }
        }
        return false;
    }

    final void zzYJv(Shape shape, boolean bl) throws Exception {
        this.zzYl6(shape, 4, bl);
        this.zzYl6(shape, 0, bl);
        this.zzYl6(shape, 1, bl);
    }

    private void zzYl6(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzX5T());
        shape2.setName(zzYiy.zzEr("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzf1() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzWL0()) {
                if (!shape.zzGp()) continue;
                shape.remove();
            }
        }
    }

    private void zzX2p(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzEr(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzMp.zzXj5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzX3t().zzWbu.zzgw(key);
        }
        return zzXU7.zz0K(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzMp.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzX3t().zzWbu.zzn1(key, value);
            return;
        }
        this.zzMp.zzn1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzMp.clear();
    }

    final boolean zz01() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzXqF() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzYl6
    implements zzYrp {
        private Section zzWnL;

        zzYl6(Section section) {
            this.zzWnL = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzWId().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzWId().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzWId().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzYrp zzWId() {
            Document document = zzXSy.zzYl6((Object)this.zzWnL.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWnL;
        }
    }
}

