/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzWEm;
import com.aspose.words.internal.zzXGM;

public abstract class SaveOptions {
    private boolean zzWZ0;
    private IDocumentSavingCallback zzZYS;
    private boolean zzBy = true;
    private boolean zzU9 = false;
    private boolean zzk = true;
    private boolean zzYwz;
    private String zzYzb;
    private boolean zzWPY;
    private boolean zzYQ3 = false;
    private boolean zzWT0 = true;
    private int zzP8 = 1;
    private int zzmJ = 1;
    private int zzWrX = 0;
    private String zzW2D = "";
    private boolean zzY6P = true;
    private boolean zzXuT = true;
    private boolean zzZyG;
    private boolean zzBI;
    private int zzWPd = 0;
    private boolean zzZ1g = true;
    private boolean zzYa3 = false;
    boolean zzUT = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZcG() {
        return false;
    }

    boolean zzZ9N() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzk;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzk = value;
    }

    public String getTempFolder() {
        return this.zzYzb;
    }

    public void setTempFolder(String value) {
        this.zzYzb = value;
    }

    public boolean getPrettyFormat() {
        return this.zzYwz;
    }

    public void setPrettyFormat(boolean value) {
        this.zzYwz = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzWPY;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzWPY = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYQ3;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYQ3 = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzWT0;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzWT0 = value;
    }

    public int getDmlRenderingMode() {
        return this.zzP8;
    }

    public void setDmlRenderingMode(int value) {
        this.zzP8 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzWrX;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzWrX = value;
    }

    public int getImlRenderingMode() {
        return this.zzmJ;
    }

    public void setImlRenderingMode(int value) {
        this.zzmJ = value;
    }

    public String getDefaultTemplate() {
        return this.zzW2D;
    }

    public void setDefaultTemplate(String value) {
        this.zzW2D = value;
    }

    public boolean getUpdateFields() {
        return this.zzY6P;
    }

    public void setUpdateFields(boolean value) {
        this.zzY6P = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzZyG;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzZyG = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzBI;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzBI = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYa3;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYa3 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzU9;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzU9 = value;
    }

    final boolean zz1E() {
        return this.zzXuT;
    }

    final boolean zzYJ2() {
        return this.zzZ1g;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzVZ0(zzXGM.zzYcs(zzWEm.zzOB(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzWPd;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzWPd = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzZYS;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzZYS = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzWZ0;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzWZ0 = value;
    }

    @Deprecated
    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzUT;
    }

    @Deprecated
    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzUT = value;
    }

    final boolean zzYPV() {
        return this.zzBy;
    }
}

