/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzYSt;
import com.aspose.words.zzAf;
import com.aspose.words.zzX0m;
import com.aspose.words.zzXMB;
import com.aspose.words.zzZ3G;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzX0m,
Iterable<T> {
    private Node zzZG0;
    private CompositeNode zzZUr;
    private DocumentBase zzVSG;
    private boolean zzWqq;
    private int zzFN;
    private int zzXTX;
    private Node zzZ21;
    private int zzXqy;
    private zzXMB zzXhS;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzAf.zzW4G(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzAf(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzXMB matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzZUr = container;
        this.zzVSG = container.getDocument();
        this.zzXhS = matcher;
        this.zzWqq = isDeep;
        this.zzYAV();
    }

    public Node get(int index) {
        try {
            this.zzJX();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzXTX == index) {
                return this.zzZ21;
            }
            int n = index - this.zzXTX;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzZsp(nodeCollection.zzZ21, n);
            if (node != null) {
                this.zzXTX = index;
                this.zzZ21 = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzWqq) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZUr.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzWqq) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZUr.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzHr();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZ3G(this);
    }

    final <TNode extends Node> zzZ3G<TNode> zzYQj() {
        return new zzZ3G(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzHr() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzYSt.zzYl6(arrayList, node);
        }
        return arrayList;
    }

    private Node zzZsp(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzWgz(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzXUN(curNode, true);
    }

    private Node zzXUN(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzZG0 = node;
        do {
            node2 = this.zzZG0;
            Node node3 = this.zzWqq ? this.zzYl6(true, this.zzZG0) : (this.zzZG0 = this.zzXhS.zzWAD() ? this.zzYJv(true, this.zzZG0) : this.zzEr(true, this.zzZG0));
        } while (this.zzZG0 != null && !this.zzXhS.zzZQw(this.zzZG0));
        return node2;
    }

    private Node zzWgz(Node node, boolean bl) throws Exception {
        while ((this.zzWqq ? this.zzYl6(bl, node) : (node = this.zzXhS.zzWAD() ? this.zzYJv(bl, node) : this.zzEr(bl, node))) != null && !this.zzXhS.zzZQw(node)) {
        }
        return node;
    }

    private Node zzYl6(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzZUr);
        }
        return node.previousPreOrder(this.zzZUr);
    }

    private Node zzEr(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzZUr) {
                return this.zzZUr.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzZUr) {
            return this.zzZUr.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzYJv(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzZUr ? this.zzZUr.zzX8n() : node.zzZvT();
        } else {
            Node node3 = node2 = node == this.zzZUr ? this.zzZUr.zzXOa() : node.zzPg();
        }
        if (node2 == this.zzZUr.getNextSibling() || node2 == this.zzZUr.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzJX() {
        if (this.zzFN != this.zzYzZ()) {
            this.zzYAV();
        }
    }

    private void zzYAV() {
        this.zzFN = this.zzYzZ();
        this.zzXTX = -1;
        this.zzZ21 = this.zzZUr;
        this.zzXqy = -1;
    }

    private int zzYzZ() {
        if (this.zzVSG != null) {
            return this.zzVSG.zzCv();
        }
        return 0;
    }

    public int getCount() {
        this.zzJX();
        if (this.zzXqy == -1) {
            this.zzXqy = zzZ3G.zzYl6(this);
        }
        return this.zzXqy;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZG0;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzZUr;
    }
}

