/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz3T;
import com.aspose.words.internal.zzXAV;
import com.aspose.words.internal.zzXGM;
import com.aspose.words.internal.zzXSy;
import com.aspose.words.internal.zzYSt;
import com.aspose.words.internal.zzZrQ;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzY8U;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzWbD = new HashMap();
    private static HashMap<Integer, Integer> zzdo = new HashMap();
    private static HashMap<Integer, Integer> zzWB3 = new HashMap();
    private static HashMap<Integer, Integer> zzVZ1 = new HashMap();
    private static HashMap<Integer, Integer> zzWJR = new HashMap();
    private static HashMap<Integer, Integer> zzeR = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzXSy.zzEr(fileName, "fileName");
        try (zz3T zz3T2 = zzXSy.zzYGt(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzW4z(zz3T2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzW4z(zzYSt.zzYl6(stream));
    }

    static FileFormatInfo zzW4z(zzXAV zzXAV2) throws Exception {
        if (zzXAV2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzY8U zzY8U2 = new zzY8U();
            zzXAV zzXAV3 = zzXAV2;
            zzY8U zzY8U3 = zzY8U2;
            return zzY8U2.zzEr(zzXAV3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzYJv(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzYeS(zzXGM.zzjz(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzVZ0(zzXGM.zzjz(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzZrQ.zzZOy(string = zzXGM.zzYEa(FileFormatUtil.zzXTt(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzYeS(FileFormatUtil.zzYN9(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzVZ0(FileFormatUtil.zzXTt(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXGM.zzYEa(FileFormatUtil.zzYN9(saveFormat));
        if (zzZrQ.zzZOy(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzVZ0(zzXGM.zzYcs(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXGM.zzYEa(FileFormatUtil.zzXfl(imageType));
    }

    static Exception zzYJv(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzIp(int n) {
        return zzXGM.toString(FileFormatUtil.zzYN9(n));
    }

    static int zzVZ0(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXSy.zzYl6(zzWJR, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWJK(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXSy.zzYl6(zzeR, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzX37(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzXTt(int n) {
        return zzXSy.zzYl6(zzWbD, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzYN9(int n) {
        return zzXSy.zzYl6(zzdo, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXfl(int n) {
        return zzXSy.zzYl6(zzWB3, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYeS(int n) {
        return zzXSy.zzYl6(zzVZ1, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXwD(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzXSy.zzEr(zzWJR, Integer.valueOf(n), Integer.valueOf(n2));
            zzXSy.zzEr(zzdo, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzVZ1.containsKey(n)) {
                zzXSy.zzEr(zzVZ1, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzXSy.zzEr(zzWbD, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzXSy.zzEr(zzeR, Integer.valueOf(n), Integer.valueOf(n4));
            zzXSy.zzEr(zzWB3, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXwD(11, 10, 10, 1);
        FileFormatUtil.zzXwD(11, 0, 0, 1);
        FileFormatUtil.zzXwD(12, 11, 11, 1);
        FileFormatUtil.zzXwD(13, 20, 20, 1);
        FileFormatUtil.zzXwD(13, 0, 254, 1);
        FileFormatUtil.zzXwD(14, 21, 21, 1);
        FileFormatUtil.zzXwD(15, 22, 22, 1);
        FileFormatUtil.zzXwD(16, 23, 23, 1);
        FileFormatUtil.zzXwD(18, 24, 24, 1);
        FileFormatUtil.zzXwD(19, 25, 25, 1);
        FileFormatUtil.zzXwD(20, 26, 26, 1);
        FileFormatUtil.zzXwD(21, 27, 27, 1);
        FileFormatUtil.zzXwD(24, 30, 30, 1);
        FileFormatUtil.zzXwD(17, 31, 31, 1);
        FileFormatUtil.zzXwD(25, 50, 50, 1);
        FileFormatUtil.zzXwD(26, 45, 255, 1);
        FileFormatUtil.zzXwD(27, 51, 51, 1);
        FileFormatUtil.zzXwD(28, 0, 52, 1);
        FileFormatUtil.zzXwD(29, 0, 53, 1);
        FileFormatUtil.zzXwD(31, 53, 54, 1);
        FileFormatUtil.zzXwD(22, 60, 60, 1);
        FileFormatUtil.zzXwD(23, 61, 61, 1);
        FileFormatUtil.zzXwD(34, 40, 64, 1);
        FileFormatUtil.zzXwD(41, 47, 255, 1);
        FileFormatUtil.zzXwD(42, 48, 255, 1);
        FileFormatUtil.zzXwD(35, 41, 255, 1);
        FileFormatUtil.zzXwD(36, 46, 255, 1);
        FileFormatUtil.zzXwD(38, 42, 255, 1);
        FileFormatUtil.zzXwD(37, 44, 255, 1);
        FileFormatUtil.zzXwD(30, 52, 55, 1);
        FileFormatUtil.zzXwD(32, 70, 62, 1);
        FileFormatUtil.zzXwD(33, 73, 63, 1);
        FileFormatUtil.zzXwD(39, 71, 255, 1);
        FileFormatUtil.zzXwD(8, 100, 255, 1);
        FileFormatUtil.zzXwD(9, 105, 255, 1);
        FileFormatUtil.zzXwD(6, 101, 255, 6);
        FileFormatUtil.zzXwD(7, 102, 255, 7);
        FileFormatUtil.zzXwD(5, 104, 255, 5);
        FileFormatUtil.zzXwD(4, 0, 255, 4);
        FileFormatUtil.zzXwD(3, 0, 255, 3);
        FileFormatUtil.zzXwD(40, 72, 255, 1);
        FileFormatUtil.zzXwD(2, 103, 255, 2);
    }
}

