/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz0h;
import com.aspose.words.internal.zzWEm;
import com.aspose.words.internal.zzWPW;
import com.aspose.words.internal.zzWV8;
import com.aspose.words.internal.zzWXO;
import com.aspose.words.internal.zzX5O;
import com.aspose.words.internal.zzXAV;
import com.aspose.words.internal.zzXPw;
import com.aspose.words.internal.zzXSy;
import com.aspose.words.internal.zzXTi;
import com.aspose.words.internal.zzXqi;
import com.aspose.words.internal.zzYSG;
import com.aspose.words.internal.zzYiy;
import com.aspose.words.internal.zzZEb;
import com.aspose.words.internal.zzZIk;
import com.aspose.words.internal.zzZVr;
import com.aspose.words.internal.zzZrQ;
import com.aspose.words.internal.zzmr;
import com.aspose.words.zzFG;
import com.aspose.words.zzIg;
import com.aspose.words.zzLk;
import com.aspose.words.zzNE;
import com.aspose.words.zzVSE;
import com.aspose.words.zzVZ0;
import com.aspose.words.zzW5A;
import com.aspose.words.zzWDV;
import com.aspose.words.zzWEL;
import com.aspose.words.zzWEU;
import com.aspose.words.zzWHc;
import com.aspose.words.zzWbR;
import com.aspose.words.zzWbq;
import com.aspose.words.zzWwc;
import com.aspose.words.zzWwi;
import com.aspose.words.zzWyN;
import com.aspose.words.zzWzF;
import com.aspose.words.zzX6C;
import com.aspose.words.zzXFJ;
import com.aspose.words.zzXKV;
import com.aspose.words.zzXNZ;
import com.aspose.words.zzXP3;
import com.aspose.words.zzXPM;
import com.aspose.words.zzXRP;
import com.aspose.words.zzXU7;
import com.aspose.words.zzXUP;
import com.aspose.words.zzXif;
import com.aspose.words.zzXoU;
import com.aspose.words.zzXtx;
import com.aspose.words.zzY3i;
import com.aspose.words.zzY3o;
import com.aspose.words.zzY4I;
import com.aspose.words.zzYBj;
import com.aspose.words.zzYNC;
import com.aspose.words.zzYU;
import com.aspose.words.zzYik;
import com.aspose.words.zzYnZ;
import com.aspose.words.zzYsV;
import com.aspose.words.zzZSY;
import com.aspose.words.zzZX4;
import com.aspose.words.zzZfg;
import com.aspose.words.zzZwx;
import com.aspose.words.zzsz;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzWEU,
zzWHc,
zzWbq {
    private Document zzZgu;
    private Node zzWfI;
    private Node zzXoR;
    private zzW5A zzWx4;
    private Font zzX4L;
    private zzWXO<zzW5A> zzps;
    private zzWXO<zzZSY> zzX78;
    private zzWXO<zzYl6> zzWZh;
    private zzFG zzZrz = zzFG.zzlA();
    private zzXKV zzYA7 = new zzXKV();
    private RowFormat zzYQJ;
    private CellFormat zz7o;
    private zzWXO<zzYBj> zzWW9;
    private int zzX6T = 0;
    private int zzWsU = -1;
    private int zzX4w;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzX4R(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzX4R(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzX4R(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYl6(documentBuilder.getCurrentSection(), zzXtx.zzZ8Q(headerFooterType), 0, 0);
    }

    private void zzX4R(int n, int n2, int n3, int n4) {
        this.zzZgu.ensureMinimum();
        Section section = (Section)this.zzZgu.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzYl6(section, 1, n3, n4);
    }

    private void zzYl6(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzXtx.zzVYO(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZgu, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZgu));
            }
        }
        this.zzYl6(story, n2, n3);
    }

    private void zzYl6(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYl6((CompositeNode)paragraph2, n3);
    }

    final void zzYl6(Paragraph paragraph, int n) {
        this.zzYl6((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzWEp().zzXN3() ? zzWEL.zzlE(this.zzZgu, fieldName) : zzWEL.zzku(this.zzWEp(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzYl6(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzYl6(field, isAfter, false);
    }

    private boolean zzYl6(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzWDV zzWDV2 = field.getFormat().zzrS();
        Inline inline = zzWDV2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzYl6(inline.zzZGt(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzZX4.zzYl6(this.zzZgu, bookmarkName) : zzZX4.zzEr(this.zzZgu, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzZZp() == 6) {
            this.zzYl6((Paragraph)node.zzYTd(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzVZ0.zzY2Z(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzYl6(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYl6(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzXhI(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzYl6(cell, characterIndex);
    }

    private void zzYl6(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzZZp() == 6) {
            this.zzYU(node);
        } else {
            Node node2 = node;
            if (zzVZ0.zzxV(node2.getNodeType())) {
                Paragraph paragraph = zzVZ0.zzY2Z(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzYU(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzZZp() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzYU(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzX4w = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzW7w();
            return;
        }
        if (!this.zzZ6r()) {
            this.zzW7w();
        }
    }

    private boolean zzZ6r() {
        Node node = this.zzWEp();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzWEp(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzYl6(inline.zzZGt(), true);
            return true;
        }
        return false;
    }

    private void zzW7w() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYl6(documentBuilder.getCurrentParagraph().zzXaK(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzXhI(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzYXk() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzWEp().zzLs(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzsZ();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzYl6((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzYna(text, false);
    }

    public void writeln(String text) {
        this.zzYna(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzZCe();
        Paragraph paragraph = this.getCurrentParagraph();
        zzY3i zzY3i2 = new zzY3i(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZgu, this.zzVY2(), this.zzXzQ());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzEr(this.zzWEp(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzY3i2.dispose();
        }
        if (this.getDocument().zzWbB()) {
            zzVZ0.zzYJv((zzZfg)paragraph, this.getDocument().zzXnA());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzY4x() {
        zzW5A zzW5A2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzZCe();
        Node node = this.zzWEp();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzYJh(false);
        } else {
            run2 = run = (Run)node.zzYbE(21);
        }
        if (run2 == null && zzXSy.zzh2(node, paragraph.zzWu())) {
            run = paragraph.zzWu();
        }
        if (run != null) {
            cloneable = run.zzZGt();
            zzW5A2 = (zzW5A)((zzYU)cloneable).zzW7g();
        } else {
            cloneable = paragraph.zzXaK();
            zzW5A2 = (zzW5A)((zzYU)cloneable).zzW7g();
        }
        zzW5A zzW5A3 = zzW5A2;
        Paragraph paragraph2 = new Paragraph(this.zzZgu, this.zzVY2(), zzW5A3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzY3i zzY3i2 = new zzY3i(this.zzZgu);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzEr(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzY3i2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXP3.zzlE(this);
    }

    public void insertBreak(int breakType) {
        this.zzWUa(breakType, true);
    }

    final void zzWUa(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzXTw(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzYWN(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzDE())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzXTw(bl)) {
                        this.zzYWN(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzXTw(bl)) {
                        this.zzXuF(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzXTw(bl)) {
                        this.zzXuF(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzXTw(bl)) {
                        this.zzXuF(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzXTw(bl)) {
                        this.zzXuF(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzXTw(bl)) {
                        this.zzXuF(4);
                    }
                    return;
                }
                case 8: {
                    this.zzYWN(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzZrQ.zzZOy(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzYiy.zzEr("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzZCe();
        return zzVZ0.zzYl6(fieldType, updateField, this.zzXzQ(), this.zzWEp(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzZCe();
        return zzVZ0.zzYl6(fieldCode, this.zzXzQ(), this.zzWEp(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzZCe();
        return zzVZ0.zzYl6(fieldCode, fieldValue, this.zzXzQ(), this.zzWEp(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzXSy.zzEr((Object)displayText, "displayText");
        zzXSy.zzEr((Object)urlOrBookmark, "hrefOrBookmark");
        zzX6C zzX6C2 = this.zzEr(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzX6C2.zzEr(documentBuilder.zzZwA(88, true));
        return zzVZ0.zzYl6(zzX6C2.getStart(), zzX6C2.getSeparator(), zzX6C2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzez(70);
        if (zzZrQ.zzZOy(name)) {
            this.startBookmark(name);
        }
        this.zzWHh(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzYG9(70);
        String string = zzZrQ.zzZOy(fieldValue) ? fieldValue : FormField.zzWrq;
        Run run = new Run(this.zzZgu, string, this.zzXzQ());
        this.insertNode(run);
        Node node = this.zzZwA(70, true);
        if (zzZrQ.zzZOy(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzWzF(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzYl6((Paragraph)node.zzYTd(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzez(71);
        if (zzZrQ.zzZOy(name)) {
            this.startBookmark(name);
        }
        this.zzWHh(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzZwA(71, false);
        if (zzZrQ.zzZOy(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzWzF(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzez(83);
        if (zzZrQ.zzZOy(name)) {
            this.startBookmark(name);
        }
        this.zzWHh(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzZwA(83, false);
        if (zzZrQ.zzZOy(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzWzF(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzZgu, footnoteType, !zzZrQ.zzZOy(referenceMark), referenceMark, this.zzXzQ());
        Style style = this.getDocument().getStyles().zzVR5(zzVZ0.zzZIg(footnoteType));
        footnote.zzZGt().set(50, style.zzWgj());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZgu);
        Style style2 = this.getDocument().getStyles().zzVR5(zzVZ0.zzXEn(footnoteType));
        paragraph.zzpS().set(1000, style2.zzWgj());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZgu, '\u0002', new zzW5A()) : new Run(this.zzZgu, footnote.getReferenceMark(), new zzW5A());
        inline.zzZGt().set(50, style.zzWgj());
        paragraph.appendChild(inline);
        if (zzZrQ.zzZOy(footnoteText)) {
            Node node = this.zzWEp();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYU(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzXDH(zzXAV zzXAV2) throws Exception {
        return this.zzYl6(zzXAV2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzXDH(zzXAV.zzEr(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzYl6(zzXAV zzXAV2, double d, double d2) throws Exception {
        return this.zzYl6(zzXAV2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzYl6(zzXAV.zzEr(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zz0h zz0h2 = new zz0h();){
            zzZVr.zzYl6(image, zz0h2);
            Shape shape = this.zzYl6(zz0h2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzXSy.zzEr(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzWPW.zzVY1(fileName);
        try {
            Shape shape = this.zzYl6((zzXAV)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzXAV)object).close();
            }
        }
    }

    private Shape zzYl6(zzXAV zzXAV2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzXAV2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzXSy.zzZpP(zzXAV2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYl6(zzXAV.zzEr(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYl6(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzYl6(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzYSG.zzYD8(object)) {
            object4 = new zzZVr((byte[])object);
            bl2 = true;
            ((zzXPw)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzZgu.getCompatibilityOptions().getMswVersion() > 12 || this.zzZgu.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzZgu, 0);
            object3 = new zzXUP();
            ((zzXPM)object3).zzYl6(zzYik.zzY5b("rect"));
            ((zzXUP)object3).zzYl6(new zzVSE());
            ((zzXUP)object3).zzY5I().zzd6().zzYJv(this.zzZgu);
            object2 = new zzIg();
            ((zzZwx)object2).zzEr(new zzWwc(this.zzZgu.zzX5T(), ""));
            ((zzZwx)object2).zzYl6(new zzY4I());
            ((zzXNZ)object3).zzYl6((zzZwx)object2);
            shape.zzN(75);
            shape.zzZpP((zzXNZ)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzZgu, 75);
        }
        if (zzYSG.zzZfO(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzYl6((byte[])object, new zzXif(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzXif(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzYSG.zzYlD((byte[])object2));
                this.zzYl6((zzXUP)shape.zzYz(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzXUP)shape.zzYz()).zzY5I().zzd6().zzWaO((byte[])object);
            object3 = zzYSG.zzZX4(object);
            object4 = new zzXif(((zzXTi)object3).getWidthPoints(), ((zzXTi)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzYl6(this.zzXzQ());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzYSG.zzVUR(object)) {
            d5 = DocumentBuilder.zzYl6(shape, object);
        }
        shape.zzYl6(d3, d4, (zzXif)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzYl6(Shape shape, byte[] byArray) throws Exception {
        int n = zzYSG.zzWFl(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzVZ0.zzWBh(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzVZ0.zzWy0(n);
        return d;
    }

    private void zzYl6(zzXUP zzXUP2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzXUP2.zzY5I().zzd6().getExtensions();
        try (zz0h zz0h2 = new zz0h(byArray);){
            object = zzVZ0.zzYl6(zz0h2, this.zzZgu);
            ((zzsz)object).zzXJJ(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzsz)object).zzXqN();
            byArray2 = ((zzsz)object).zzYGo(true);
        }
        zzXUP2.zzY5I().zzd6().setExtensions(new zzmr<zzYnZ>());
        object = zzYnZ.zzYl6(byArray2, this.zzZgu);
        zzXUP2.zzY5I().zzd6().getExtensions().zzW5C(((zzYnZ)object).getUri(), (zzYnZ)object);
    }

    private Shape zzYl6(zzXAV zzXAV2, String string, boolean bl, zzXAV zzXAV3) throws Exception {
        zzLk zzLk2 = zzLk.zzxV(string);
        Shape shape = this.zzYl6(zzXAV3, bl, zzLk2, null);
        zzYNC zzYNC2 = zzXoU.zzYl6(zzXAV2, string, bl);
        return DocumentBuilder.zzYl6(null, false, shape, zzLk2.zzYf7, zzYNC2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYl6(zzXAV.zzEr(stream), progId, asIcon, zzXAV.zzEr(presentation));
    }

    private Shape zzYl6(String string, boolean bl, boolean bl2, zzXAV zzXAV2) throws Exception {
        zzLk zzLk2 = zzLk.zzWWV(zzWEm.zzOB(string));
        return this.zzYl6(string, bl, bl2, zzXAV2, zzLk2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYl6(fileName, isLinked, asIcon, zzXAV.zzEr(presentation));
    }

    private Shape zzYl6(String string, String string2, boolean bl, boolean bl2, zzXAV zzXAV2) throws Exception {
        zzLk zzLk2 = zzLk.zzxV(string2);
        return this.zzYl6(string, bl, bl2, zzXAV2, zzLk2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYl6(fileName, progId, isLinked, asIcon, zzXAV.zzEr(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzLk zzLk2 = zzLk.zzWWV(zzWEm.zzOB(fileName));
        return this.zzYl6(fileName, isLinked, iconFile, iconCaption, zzLk2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzLk zzLk2 = zzLk.zzxV(progId);
        return this.zzYl6(fileName, isLinked, iconFile, iconCaption, zzLk2);
    }

    private Shape zzYl6(zzXAV zzXAV2, String string, String string2, String string3) throws Exception {
        zzLk zzLk2 = zzLk.zzxV(string);
        Shape shape = this.zzYl6(string2, string3, zzLk2);
        zzYNC zzYNC2 = zzXoU.zzYl6(zzXAV2, string, true);
        return DocumentBuilder.zzYl6(null, false, shape, zzLk2.zzYf7, zzYNC2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzYl6(zzXAV.zzEr(stream), progId, iconFile, iconCaption);
    }

    final Shape zzYl6(zzYsV zzYsV2, zzXAV zzXAV2) throws Exception {
        Shape shape = this.zzYWd(zzXAV2);
        shape.zzN(201);
        shape.getOleFormat().zzEr(zzYsV2.zzXgC());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzZCe();
        if (this.zzZYV()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzXna(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzXRP zzXRP2 = zzVZ0.zzYl6(html, options, this);
        zzXRP2.zzYHi();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzZCe();
        return zzVZ0.zzYl6(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzZCe();
        return zzVZ0.zzYl6(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzWwi zzWwi2 = new zzWwi();
        return zzWwi2.zzYl6(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzNE(this).zzYl6(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzNE(this).zzYl6(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZgu, 75);
        shape.zzYl6(this.zzXzQ());
        shape.zzZTc(true);
        shape.getSignatureLine().zzYl6(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zz4t(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzWlq(this.zzZgu);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzZYV() {
        boolean bl = false;
        if (this.zzWEp().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzWEp().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzXna(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzZCe();
        if (this.zzYXk() == null) {
            this.startTable();
        }
        if (this.zzYXk().zzYuH() == 1) {
            this.zzYXk().zzYYJ();
        }
        if (this.zzYXk().zzYuH() == 3) {
            this.zzYXk().zz5B();
        }
        return this.zzYXk().zzY6s();
    }

    public Table startTable() {
        this.zzWW9.push(new zzYBj(this));
        return this.zzYXk().startTable();
    }

    public Table endTable() {
        if (this.zzYXk() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzYXk().endTable();
        this.zzWW9.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzYXk() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzYXk().endRow();
        if (this.zzX4L != null && this.zzX4L.getHidden()) {
            row.zzWoK().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZgu, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZgu, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWQM();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZgu, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzV();
        bookmarkStart.zzXlt(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWQM();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzV();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZgu, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzYWH(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZgu);
        this.zzWsU = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzWsU == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZgu, this.zzWsU);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZgu, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzXSy.zzEr((Object)importFormatOptions, "ImportFormatOptions");
        this.zzZCe();
        return zzY3o.zzYl6(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzZgu;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZgu) {
            return;
        }
        this.zzZgu = value;
        this.zzYU(null);
        this.zzWx4 = new zzW5A();
        this.zzps = null;
        this.zzX78 = null;
        this.zzX4L = null;
        this.zzWW9 = new zzWXO();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzX4L == null) {
            DocumentBuilder documentBuilder = this;
            this.zzX4L = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzX4L;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzYQJ == null) {
            this.zzYQJ = new RowFormat(this);
        }
        return this.zzYQJ;
    }

    public CellFormat getCellFormat() {
        if (this.zz7o == null) {
            this.zz7o = new CellFormat(this);
        }
        return this.zz7o;
    }

    final void zzW9i(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzW5A zzW5A2 = this.getCurrentParagraph().zzXaK();
        this.zzZ00().push(new zzYl6(this.zzXzQ(), (zzW5A)zzW5A2.zzW7g()));
    }

    public void popFont() {
        zzWXO<zzYl6> zzWXO2 = this.zzZ00();
        if (zzWXO2.size() > 0) {
            zzYl6 zzYl62 = (zzYl6)this.zzZ00().pop();
            this.zzYl6(zzYl62.zzZGt(), false);
            this.getCurrentParagraph().zzvu(zzYl62.zzZBA());
        }
    }

    final void zzWHw() {
        this.zzZvZ().push(this.zzXzQ());
    }

    final void zzXg8() {
        zzWXO<zzW5A> zzWXO2 = this.zzZvZ();
        if (zzWXO2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzYl6((zzW5A)documentBuilder.zzZvZ().pop(), false);
        }
    }

    final void zzKt() {
        this.zzZT3().push(this.zzVY2());
    }

    final void zzWKi() {
        zzWXO<zzZSY> zzWXO2 = this.zzZT3();
        if (zzWXO2.size() > 0) {
            this.getCurrentParagraph().zzYl6((zzZSY)this.zzZT3().pop());
        }
    }

    final zzX6C zzEr(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzez(88);
        zzWbR zzWbR2 = new zzWbR();
        zzWbR2.setTarget(string2);
        zzWbR2.setScreenTip(string3);
        if (bl) {
            zzWbR2.setSubAddress(string);
        } else {
            zzWbR2.setAddress(zzXqi.zzYDE(string));
            zzWbR2.setSubAddress(zzXqi.zzp6(string));
        }
        this.zzWHh(zzWbR2.zzZku());
        FieldSeparator fieldSeparator = this.zzYG9(88);
        return new zzX6C(fieldStart, fieldSeparator, null);
    }

    final zzX6C zzn1(String string, String string2, String string3) {
        boolean bl = zzXqi.zzrk(string);
        String string4 = bl ? zzXqi.zzp6(string) : string;
        return this.zzEr(string4, bl, string2, string3);
    }

    final FieldEnd zzWXP() {
        return this.zzZwA(88, true);
    }

    final zzW5A zzXzQ() {
        zzW5A zzW5A2 = this.zzWx4;
        return (zzW5A)zzW5A2.zzW7g();
    }

    final zzZSY zzVY2() {
        zzZSY zzZSY2 = this.getCurrentParagraph().zzpS();
        return (zzZSY)zzZSY2.zzW7g();
    }

    final zzFG zzZpd() {
        zzFG zzFG2 = this.zzWoK();
        return (zzFG)zzFG2.zzW7g();
    }

    final zzXKV zz2G() {
        zzXKV zzXKV2 = this.zzWUt();
        return (zzXKV)zzXKV2.zzW7g();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzWEp(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzWEp().getNodeType() == 8;
    }

    private void zzYna(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzXtx.zzYle(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzXvV(string2.substring(n4, n4 + n2));
                }
                switch (this.zzX6T) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzYWN(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzXvV(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzZCe();
        if (this.zzYXk() != null && this.zzYXk().zzYuH() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzWEp().getParentNode().insertBefore(node, this.zzWEp());
    }

    final void zzVR6(int n) {
        this.zzXTw(true);
        this.zzXuF(n);
    }

    private void zzXuF(int n) {
        this.insertParagraph();
        zzY3i zzY3i2 = new zzY3i(this.getDocument());
        try {
            zzXU7 zzXU72 = this.getCurrentSection().zzZ5r();
            zzXU7 zzXU73 = (zzXU7)zzXU72.zzW7g();
            Section section = new Section(this.zzZgu, zzXU73);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZgu));
            this.zzZgu.insertAfter(section, this.getCurrentSection());
            section.getBody().zzEr(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzY3i2.dispose();
        }
    }

    final FieldStart zzez(int n) {
        this.zzZCe();
        return zzVZ0.zzYl6(n, this.zzXzQ(), this.zzWEp(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzWHh(String string) {
        return zzVZ0.zzEr(string, this.zzXzQ(), this.zzWEp(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzZwA(int n, boolean bl) {
        return zzVZ0.zzEr(n, bl, this.zzXzQ(), this.zzWEp(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzYG9(int n) {
        return zzVZ0.zzEr(n, this.zzXzQ(), this.zzWEp(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzWzF(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZgu, new zzXFJ(), this.zzXzQ());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzXTw(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzYXk() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzXhI(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzXvV(String string) {
        if (this.zzs5(string)) {
            zzZEb zzZEb2 = new zzZEb(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzWV8 zzWV82 : zzZEb2.zzZIq(this.getParagraphFormat().getBidi())) {
                zzWzF zzWzF2 = zzWzF.zz6f(zzWV82.zzZsh());
                zzW5A zzW5A2 = this.zzXzQ();
                zzW5A2.zzn1(265, zzWzF2);
                if (zzWV82.zz84()) {
                    zzW5A2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZgu, zzWV82.getText(), zzW5A2);
                this.insertNode(run);
            }
            return;
        }
        this.zzYWN(string);
    }

    private boolean zzs5(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzZIk.zzYC1(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzYl6(zzW5A zzW5A2, boolean bl) {
        zzW5A zzW5A3;
        if (bl) {
            zzW5A zzW5A4 = zzW5A2;
            zzW5A3 = (zzW5A)zzW5A4.zzW7g();
        } else {
            zzW5A3 = zzW5A2;
        }
        this.zzWx4 = zzW5A3;
    }

    final void zzY3b() {
        this.zzWx4.clear();
    }

    final void zzVPS() {
        if (this.zzWQM() != null) {
            zzXKV zzXKV2;
            zzXKV zzXKV3 = zzXKV2 = this.zzWQM().zzWUt();
            this.zzYA7 = (zzXKV)zzXKV3.zzW7g();
            zzXKV2.zzEr(this.zzYA7);
        }
    }

    private Shape zzYl6(String string, boolean bl, boolean bl2, zzXAV zzXAV2, zzLk zzLk2) throws Exception {
        if (zzLk2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzYl6(zzXAV2, bl2, zzLk2, string);
        zzYNC zzYNC2 = zzXoU.zzYl6(string, bl, bl2, zzLk2);
        return DocumentBuilder.zzYl6(string, bl, shape, zzLk2.zzYf7, zzYNC2);
    }

    private Shape zzYl6(String string, boolean bl, String string2, String string3, zzLk zzLk2) throws Exception {
        if (zzLk2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzWEm.zzXjO(string);
        }
        Shape shape = string2 != null ? this.zzZX4(string2, string3) : this.zzYl6(null, string3, zzLk2);
        zzYNC zzYNC2 = zzXoU.zzYl6(string, bl, true, zzLk2);
        return DocumentBuilder.zzYl6(string, bl, shape, zzLk2.zzYf7, zzYNC2);
    }

    private static Shape zzYl6(String string, boolean bl, Shape shape, String string2, zzYNC zzYNC2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzN(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzEr(zzYNC2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzYl6(zzXAV zzXAV2, boolean bl, zzLk zzLk2, String string) throws Exception {
        if (zzLk2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzXAV2 != null) {
            return this.zzYWd(zzXAV2);
        }
        if (!bl) {
            return this.zzYEi(zzXoU.zzXT3().get("normal"));
        }
        String string2 = string != null ? zzWEm.zzXjO(string) : zzXoU.zzZKd(zzLk2.zzXAy);
        return this.zzYl6(zzLk2, string2);
    }

    private Shape zzYl6(String string, String string2, zzLk zzLk2) throws Exception {
        if (zzLk2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzXoU.zzZKd(zzLk2.zzXAy);
        }
        if (string != null) {
            return this.zzZX4(string, string2);
        }
        return this.zzYl6(zzLk2, string2);
    }

    private Shape zzYl6(zzLk zzLk2, String string) throws Exception {
        if (zzLk2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzXoU.zzZAs(zzLk2.zzXAy);
        zzX5O zzX5O2 = new zzX5O(byArray, null, string, this.getDocument().zzX0c());
        return this.zzYEi(zzX5O2.zzYGU());
    }

    private Shape zzZX4(String string, String string2) throws Exception {
        zzX5O zzX5O2 = new zzX5O(string, string2, this.getDocument().zzX0c());
        return this.zzYEi(zzX5O2.zzYGU());
    }

    private Shape zzYWd(zzXAV zzXAV2) throws Exception {
        byte[] byArray = zzXSy.zzZpP(zzXAV2);
        return this.zzYEi(byArray);
    }

    private Shape zzYEi(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZgu, 1);
        shape.zzN(75);
        shape.zzYl6(this.zzXzQ());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zz4t(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzYl6(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzEr(compositeNode, n);
            return;
        }
        this.zzYJv(compositeNode, n);
    }

    private void zzEr(CompositeNode compositeNode, int n) {
        zzWyN zzWyN2 = zzWyN.zzWgz(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzWyN2.zzYl6(null, true, true, true, false, true);
            node = zzWyN2.getNode();
            if (zzWyN2.zzH8() && (!node.isComposite() || node.zzZZp() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzXsH().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzYl6(null, node);
            this.zzX4w = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzYJv(CompositeNode compositeNode, int n) {
        zzWyN zzWyN2 = zzWyN.zzX8S(compositeNode);
        while (zzWyN2.getNode() != compositeNode || !zzWyN2.zzH8()) {
            int n2;
            Node node = zzWyN2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzXsH().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzYl6(null, node);
                this.zzX4w = n;
                return;
            }
            while (zzWyN2.zzYl6(null, false, true, true, false, true) && zzWyN2.zzH8() && zzWyN2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzZCe() {
        int n = this.zzX4w;
        if (n == 0) {
            return;
        }
        this.zzX4w = 0;
        Run run = zzXSy.zzYl6((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzVPa(n);
        }
    }

    private Run zzYWN(String string) {
        Run run = new Run(this.zzZgu, string, this.zzXzQ());
        this.insertNode(run);
        return run;
    }

    final boolean zzSw() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzAn() {
        return this.zzX6T;
    }

    final void zzZ9Z(int n) {
        this.zzX6T = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzWEp();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzWEp();
        }
        return (Paragraph)this.zzWEp().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYBj zzYXk() {
        zzWXO<zzYBj> zzWXO2 = this.zzWW9;
        if (zzWXO2.size() > 0) {
            return (zzYBj)this.zzWW9.peek();
        }
        return null;
    }

    private Cell zzWQM() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZj5();
    }

    private zzWXO<zzW5A> zzZvZ() {
        if (this.zzps == null) {
            this.zzps = new zzWXO();
        }
        return this.zzps;
    }

    private zzWXO<zzZSY> zzZT3() {
        if (this.zzX78 == null) {
            this.zzX78 = new zzWXO();
        }
        return this.zzX78;
    }

    private zzWXO<zzYl6> zzZ00() {
        if (this.zzWZh == null) {
            this.zzWZh = new zzWXO();
        }
        return this.zzWZh;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzWx4.zzXj5(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzYH7(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzYH7(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzWx4.zzn1(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zziO()) {
            this.getCurrentParagraph().zzXaK().zzn1(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzWx4.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzWx4.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zziO()) {
            this.getCurrentParagraph().zzXaK().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWoK().zzXj5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWoK().zzgw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWoK().zzCV(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWoK().zzn1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWoK().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWoK().clear();
        zzFG.zzlA().zzEr(this.zzWoK());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWUt().zzXj5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzWUt().zzgw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzWUt().zzCV(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzXSy.zzYl6(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzWQM() != null ? this.zzWQM().getCellFormat() : this.getCellFormat();
            border.zzYl6(cellFormat);
        }
        this.zzWUt().zzn1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWUt().clear();
    }

    private Node zzWEp() {
        Node node = this.zzWfI != null && this.zzWfI.getParentNode() == null ? this.zzXoR : this.zzWfI;
        if (node != null && node.zzZZp() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzYU(Node node) {
        this.zzWfI = node;
        if (this.zzWfI != null) {
            this.zzXoR = this.zzWfI.getParentNode();
        }
    }

    private zzFG zzWoK() {
        if (this.zzYXk() != null && this.zzYXk().zzYuH() == 1) {
            return this.zzZrz;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWoK();
        }
        return this.zzZrz;
    }

    private zzXKV zzWUt() {
        if (this.zzYXk() != null && this.zzYXk().zzYuH() != 3) {
            return this.zzYA7;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZj5().zzWUt();
        }
        return this.zzYA7;
    }

    static final class zzYl6 {
        private zzW5A zzWx4;
        private zzW5A zzWEA;

        public zzYl6(zzW5A zzW5A2, zzW5A zzW5A3) {
            this.zzWx4 = zzW5A2;
            this.zzWEA = zzW5A3;
        }

        public final zzW5A zzZGt() {
            return this.zzWx4;
        }

        public final zzW5A zzZBA() {
            return this.zzWEA;
        }
    }
}

