/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzXSy;
import com.aspose.words.zzVZ0;
import com.aspose.words.zzWTZ;
import com.aspose.words.zzX0m;
import com.aspose.words.zzXmI;
import com.aspose.words.zzXme;
import com.aspose.words.zzY3i;
import com.aspose.words.zzZ3G;
import com.aspose.words.zzZIk;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzX0m,
Iterable<T> {
    private Node zzZkV;
    private Node zzWVX;
    private Node zzZG0;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzEr((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzYck() {
        return this.zzX8n() != null;
    }

    final boolean zzZqc() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzZwG() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzXmI) {
                return true;
            }
            CompositeNode compositeNode = zzXSy.zzYl6((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzZwG()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzZkV;
    }

    public Node getLastChild() {
        return this.zzWVX;
    }

    final Node zzX8n() {
        return zzVZ0.zzX81(this.getFirstChild(), false);
    }

    final Node zzXOa() {
        return zzVZ0.zzWz8(this.getLastChild(), false);
    }

    final CompositeNode zzYbl() {
        return (CompositeNode)zzVZ0.zzX81(this.getFirstChild(), true);
    }

    final CompositeNode zzWjZ() {
        return (CompositeNode)zzVZ0.zzWz8(this.getLastChild(), true);
    }

    final Node zzW1r() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzVZ0.zzxV((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzZ4t() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzVZ0.zzxV((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzYl6(boolean bl, zzXme zzXme2) {
        CompositeNode compositeNode = (CompositeNode)super.zzYl6(bl, zzXme2);
        ((CompositeNode)super.zzYl6(bl, zzXme2)).zzWVX = null;
        compositeNode.zzZkV = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWmS(node.zzYl6(true, zzXme2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZxd(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZxd(StringBuilder stringBuilder) {
        this.zzh2(stringBuilder);
        zzXSy.zzEr(stringBuilder, this.zzXsH());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzEr(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzVZ0.zzWWV(nodeType);
            Node node2 = node = bl ? this.zzX8n() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZvT() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZIk.zzYJv(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZIk.zzX2p(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZ3G(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzYl6(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzYl6(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzEr(oldChild, false);
    }

    private Node zzEr(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzYl6(node, (Node)this, null, 1);
        if (documentBase.zzWbB() && zzVZ0.zzMt(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzYl6(nodeChangingArgs);
        }
        if (!bl && zzVZ0.zzVWy(node)) {
            zzVZ0.zzn1(node, false);
        }
        Node node2 = this.zzXp0(node);
        if (nodeChangingArgs != null) {
            documentBase.zzEr(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzWTZ.zz4t(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWmS(Node node) {
        node.getParentNode();
        if (this.zzWVX == null) {
            node.zzW69(null);
            node.zzW6n(null);
            this.zzZkV = node;
        } else {
            node.zzW69(this.zzWVX);
            node.zzW6n(null);
            this.zzWVX.zzW6n(node);
        }
        this.zzWVX = node;
        node.zzZvF(this);
        return node;
    }

    final void zzYl6(Node node, Node node2, Node node3) {
        this.zzYl6(node, node2, node3, false);
    }

    final void zzYl6(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzlE(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzEr(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzYJv(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzVZ0.zzxV(node3.getNodeType())) continue;
            if (zzVZ0.zzZpP(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzXsH().length();
    }

    String zzXsH() {
        return "";
    }

    final String zzXYp() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzh2(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzh2(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZxd(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzYl6(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzEr(visitor));
    }

    abstract int zzYl6(DocumentVisitor var1) throws Exception;

    abstract int zzEr(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzlE(Node var1);

    final Node zzYl6(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzLs(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzlE(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzY3i(documentBase);
            try {
                compositeNode.zzEr(node, true);
            }
            finally {
                ((zzY3i)object).dispose();
            }
        }
        if ((object = documentBase.zzYl6(node, null, (Node)this, 0)) != null) {
            documentBase.zzYl6((NodeChangingArgs)object);
        }
        if (this.zzWVX == null) {
            node.zzW69(null);
            node.zzW6n(null);
            this.zzZkV = node;
            this.zzWVX = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzEr(node, node2);
            } else {
                this.zzYJv(node, this.zzZkV);
            }
        } else if (node2 != null) {
            this.zzYJv(node, node2);
        } else {
            this.zzEr(node, this.zzWVX);
        }
        node.zzZvF(this);
        if (object != null) {
            documentBase.zzEr((NodeChangingArgs)object);
        }
        if (documentBase.zzWbB()) {
            zzVZ0.zzYl6(node, compositeNode, node3);
        }
        return node;
    }

    private void zzEr(Node node, Node node2) {
        Node node3 = node2.zzY76();
        node.zzW69(node2);
        node.zzW6n(node3);
        node2.zzW6n(node);
        if (node3 == null) {
            this.zzWVX = node;
            return;
        }
        node3.zzW69(node);
    }

    private void zzYJv(Node node, Node node2) {
        Node node3 = node2.zzXMW();
        node.zzW69(node3);
        node.zzW6n(node2);
        node2.zzW69(node);
        if (node3 == null) {
            this.zzZkV = node;
            return;
        }
        node3.zzW6n(node);
    }

    private Node zzXp0(Node node) {
        if (node == this.zzZkV) {
            if (this.zzZkV == this.zzWVX) {
                this.zzZkV = null;
                this.zzWVX = null;
            } else {
                this.zzZkV = node.zzY76();
                this.zzZkV.zzW69(null);
            }
        } else {
            Node node2 = node.zzXMW();
            Node node3 = node.zzY76();
            node2.zzW6n(node3);
            if (node3 == null) {
                this.zzWVX = node2;
            } else {
                node3.zzW69(node2);
            }
        }
        node.zzW6n(null);
        node.zzW69(null);
        node.zzZvF(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzZG0 = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZG0;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

