/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzWSf;
import com.aspose.words.internal.zzXSy;
import com.aspose.words.zzW4Y;
import com.aspose.words.zzWh6;
import com.aspose.words.zzX8c;
import com.aspose.words.zzXdn;
import com.aspose.words.zzYZM;
import com.aspose.words.zzYvq;
import com.aspose.words.zzZ52;
import com.aspose.words.zzZEW;
import com.aspose.words.zzZYY;
import com.aspose.words.zzfa;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzYvq zz7U;

    ChartSeriesCollection(zzYvq dmlChart) {
        this.zz7U = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zz7U.zzZ3j().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zz7U.zzZ3j().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zz7U.zzZ3j().removeAt(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zz7U.zzZ3j().clear();
        this.zzW6n(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYl6(seriesName, values);
        chartSeries.zzXBY().zzX2p(ChartSeriesCollection.zzZxd(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYl6(seriesName, yValues);
        chartSeries.zzXBY().zzX2p(ChartSeriesCollection.zzX2p(xValues));
        return chartSeries;
    }

    private ChartSeries zzYl6(String string, zzWSf[] zzWSfArray, double[] dArray) {
        if (zzWSfArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzWSfArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzWSfArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYl6(string, dArray);
        chartSeries.zzXBY().zzX2p(ChartSeriesCollection.zzYl6(zzWSfArray));
        if (!this.zz7U.zzZ84()) {
            this.zzW6n(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzYl6(seriesName, zzWSf.zzYl6(dates), values);
    }

    private void zzW6n(boolean bl) {
        zzX8c zzX8c2 = zzXSy.zzYl6((Object)this.zz7U, zzX8c.class);
        if (zzX8c2 != null && zzX8c2.zzXiv().zzZ2E()) {
            zzX8c2.zzXiv().zzXMi().zzh2(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zz7U.zzWBx() != 15) {
            this.zz7U.zzYtN(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzYl6(seriesName, yValues);
        chartSeries.zzWTa().zzYFG().zzh2(3, this.zz7U.zzWVF());
        chartSeries.zzXBY().zzX2p(ChartSeriesCollection.zzX2p(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzXJn().zzX2p(ChartSeriesCollection.zzX2p(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzYl6(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zz7U);
        chartSeries.setName(string);
        this.zzX4R(chartSeries);
        chartSeries.zzBd(this.zz7U.zzZ2Y().zzWEx() + 1);
        chartSeries.zzYeT(this.zz7U.zzZ2Y().zzZM7() + 1);
        chartSeries.zzZhn().zzX2p(ChartSeriesCollection.zzX2p(dArray));
        this.zz7U.zzqq().zzZRp();
        this.zz7U.zzZ3j().zzWNz(chartSeries);
        return chartSeries;
    }

    private void zzX4R(ChartSeries chartSeries) {
        chartSeries.zzWTa().zzYFG().zzh2(5, new zzZ52());
        switch (this.zz7U.zzWBx()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzYl6(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzYl6(chartSeries, 5);
                ChartSeriesCollection.zzXwD(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzYl6(chartSeries, 1);
                ChartSeriesCollection.zzXwD(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzn1(chartSeries);
            }
        }
    }

    private static void zzn1(ChartSeries chartSeries) {
        zzZ52 zzZ522 = new zzZ52();
        zzZ522.setOutline(new zzZEW());
        zzW4Y zzW4Y2 = new zzW4Y();
        zzW4Y2.zzYb(1);
        zzZ522.getOutline().setFill(new zzfa(zzW4Y2));
        zzZ522.getOutline().zzZuV(19050.0);
        chartSeries.zzWTa().zzYFG().zzh2(5, zzZ522);
    }

    private static void zzXwD(ChartSeries chartSeries) {
        zzZ52 zzZ522 = new zzZ52();
        zzZ522.setOutline(new zzZEW());
        zzZ522.getOutline().setFill(new zzYZM());
        zzZ522.getOutline().setEndCap(0);
        zzZ522.getOutline().zzZuV(19050.0);
        chartSeries.zzWTa().zzYFG().zzh2(5, zzZ522);
    }

    private static void zzYl6(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzWBn());
        chartMarker.zzXKx().zzh2(0, n);
        chartSeries.zzWTa().zzYFG().zzh2(4, chartMarker);
    }

    private static zzWh6 zzX2p(double[] dArray) {
        int n = 0;
        zzWh6 zzWh62 = new zzWh6(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzWh62.zzlE(new zzZYY(n, d, "General"));
            }
            ++n;
        }
        zzWh62.zzYnZ(dArray.length);
        return zzWh62;
    }

    private static zzWh6 zzYl6(zzWSf[] zzWSfArray) {
        int n = 0;
        zzWh6 zzWh62 = new zzWh6(2);
        zzWSf[] zzWSfArray2 = zzWSfArray;
        int n2 = zzWSfArray.length;
        for (int i = 0; i < n2; ++i) {
            zzWSf zzWSf2 = zzWSfArray2[i];
            zzWh62.zzlE(new zzZYY(n++, zzWSf2.zzWxJ(), "m/d/yyyy"));
        }
        zzWh62.zzYnZ(zzWSfArray.length);
        return zzWh62;
    }

    private static zzWh6 zzZxd(String[] stringArray) {
        int n = 0;
        zzWh6 zzWh62 = new zzWh6(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzWh62.zzlE(new zzXdn(n++, string));
        }
        zzWh62.zzYnZ(stringArray.length);
        return zzWh62;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zz7U.zzZ3j().getCount();
    }
}

