/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYP4;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzWOc;
import com.aspose.words.net.System.Data.zzWdc;
import com.aspose.words.net.System.Data.zzXMK;
import com.aspose.words.net.System.Data.zzXlm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzZG9;
    private final DataColumnCollection zzW5N;
    private final ConstraintCollection zzZtN;
    private final zzWdc zzXkq;
    private ResultSet zzPf;
    private String zzWzz;
    private DataSet zzZn2;
    private String zzYPD;
    private UniqueConstraint zzaY;
    private boolean zzXsZ;
    private final List<DataTableEventListener> zzYlA;
    private final Set<DataRow> zzWMQ;
    private DataRelationCollection zzZFk;

    public DataTable() {
        this.zzZG9 = new DataRowCollection(this);
        this.zzW5N = new DataColumnCollection(this);
        this.zzZtN = new ConstraintCollection(this);
        this.zzXkq = new zzWdc(this);
        this.zzYPD = "";
        this.zzXsZ = true;
        this.zzYlA = new ArrayList<DataTableEventListener>();
        this.zzWMQ = new HashSet<DataRow>();
        this.zzZFk = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzZG9 = new DataRowCollection(this);
        this.zzW5N = new DataColumnCollection(this);
        this.zzZtN = new ConstraintCollection(this);
        this.zzXkq = new zzWdc(this);
        this.zzYPD = "";
        this.zzXsZ = true;
        this.zzYlA = new ArrayList<DataTableEventListener>();
        this.zzWMQ = new HashSet<DataRow>();
        this.zzZFk = new DataRelationCollection();
        this.zzWzz = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzWOc.zzYn3(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzZG9 = new DataRowCollection(this);
        this.zzW5N = new DataColumnCollection(this);
        this.zzZtN = new ConstraintCollection(this);
        this.zzXkq = new zzWdc(this);
        this.zzYPD = "";
        this.zzXsZ = true;
        this.zzYlA = new ArrayList<DataTableEventListener>();
        this.zzWMQ = new HashSet<DataRow>();
        this.zzZFk = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzPf = resultSet;
        this.zzWzz = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzPf != null) {
            if (this.zzPf.getStatement() != null) {
                this.zzPf.getStatement().getConnection().close();
            }
            this.zzPf = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzWzz;
    }

    public void setTableName(String tableName) {
        this.zzWzz = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzW5N.getCount();
    }

    public String getColumnName(int index) {
        return this.zzW5N.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzPf;
    }

    public DataSet getDataSet() {
        return this.zzZn2;
    }

    final void zzAY(DataSet dataSet) {
        this.zzZn2 = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzZn2.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzZFk.add(dataRelation);
        }
        return this.zzZFk;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzZn2.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzZG9;
    }

    public DataColumnCollection getColumns() {
        return this.zzW5N;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzZtN;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzaY == null) {
            return new DataColumn[0];
        }
        return this.zzaY.getColumns();
    }

    final void zzWdc(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzaY != null) {
                this.zzaY.zzXom(false);
                this.getConstraints().remove(this.zzaY);
                this.zzaY = null;
            }
            return;
        }
        if (this.zzaY != null && DataColumn.areColumnSetsTheSame(value, this.zzaY.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzYn3(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzaY != null) {
            this.zzaY.zzXom(false);
            this.getConstraints().remove(this.zzaY);
            this.zzaY = null;
        }
        UniqueConstraint.zzYn3(this.getConstraints(), uniqueConstraint);
        this.zzaY = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzYPD;
    }

    public void setNamespace(String namespace) {
        this.zzYPD = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXsZ;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXsZ = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzWMQ.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzWOc.zzYn3(this.getResultSet(), this);
            zzWOc.zzWOc(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzYP4.zzAY(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzWOc.zzWfA(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzYlA.contains(listener)) {
            this.zzYlA.add(listener);
        }
    }

    public void removeEventListener(zzXlm listener) {
        if (this.zzYlA.contains(listener)) {
            this.zzYlA.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzYlA.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzWMQ.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYlA) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzWMQ.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYlA) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzWMQ.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYlA) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYlA) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYlA) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXMK zzYn3(zzWOc[] zzWOcArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzWOcArray.length];
        for (int i = 0; i < zzWOcArray.length; ++i) {
            dataColumnArray[i] = zzWOcArray[i].zzYg5();
        }
        DataTable dataTable = this;
        zzXMK zzXMK2 = dataTable.zzXkq.zzAY(dataColumnArray);
        if (zzXMK2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXMK2;
    }

    final zzWdc zzX8j() {
        return this.zzXkq;
    }

    final Set<DataRow> zzrG() {
        return this.zzWMQ;
    }
}

